/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.commons.items;

import android.support.v7.widget.RecyclerView;
import com.mikepenz.fastadapter.IExpandable;
import com.mikepenz.fastadapter.IItem;
import com.mikepenz.fastadapter.ISubItem;
import com.mikepenz.fastadapter.items.GenericAbstractItem;
import java.util.List;

public abstract class GenericAbstractExpandableItem<Model, Parent extends GenericAbstractItem<Model, Parent, VH> & ISubItem, VH extends RecyclerView.ViewHolder, SubItem extends IItem & ISubItem>
extends GenericAbstractItem<Model, Parent, VH>
implements IExpandable<GenericAbstractExpandableItem, SubItem>,
ISubItem<GenericAbstractExpandableItem, Parent> {
    private List<SubItem> mSubItems;
    private Parent mParent;
    private boolean mExpanded = false;

    public GenericAbstractExpandableItem(Model model) {
        super(model);
    }

    public boolean isExpanded() {
        return this.mExpanded;
    }

    public GenericAbstractExpandableItem<Model, Parent, VH, SubItem> withIsExpanded(boolean expanded) {
        this.mExpanded = expanded;
        return this;
    }

    public List<SubItem> getSubItems() {
        return this.mSubItems;
    }

    public boolean isAutoExpanding() {
        return true;
    }

    public GenericAbstractExpandableItem<Model, Parent, VH, SubItem> withSubItems(List<SubItem> subItems) {
        this.mSubItems = subItems;
        for (IItem subItem : subItems) {
            ((ISubItem)subItem).withParent((IItem)this);
        }
        return this;
    }

    public Parent getParent() {
        return this.mParent;
    }

    public GenericAbstractExpandableItem<Model, Parent, VH, SubItem> withParent(Parent parent) {
        this.mParent = parent;
        return this;
    }

    public boolean isSelectable() {
        return this.getSubItems() == null;
    }
}

