/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.fastadapter.commons.utils;

import android.content.Context;
import android.content.res.ColorStateList;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.RippleDrawable;
import android.graphics.drawable.ShapeDrawable;
import android.graphics.drawable.StateListDrawable;
import android.graphics.drawable.shapes.RoundRectShape;
import android.graphics.drawable.shapes.Shape;
import android.os.Build;
import android.support.annotation.ColorInt;
import android.support.v4.content.ContextCompat;
import android.util.TypedValue;
import com.mikepenz.fastadapter.R;
import java.util.Arrays;

public class FastAdapterUIUtils {
    public static StateListDrawable getSelectableBackground(Context ctx, @ColorInt int selected_color, boolean animate) {
        StateListDrawable states = new StateListDrawable();
        ColorDrawable clrActive = new ColorDrawable(selected_color);
        states.addState(new int[]{0x10100A1}, (Drawable)clrActive);
        states.addState(new int[0], ContextCompat.getDrawable((Context)ctx, (int)FastAdapterUIUtils.getSelectableBackground(ctx)));
        if (animate) {
            int duration = ctx.getResources().getInteger(0x10E0000);
            states.setEnterFadeDuration(duration);
            states.setExitFadeDuration(duration);
        }
        return states;
    }

    public static StateListDrawable getSelectablePressedBackground(Context ctx, @ColorInt int selected_color, int pressed_alpha, boolean animate) {
        StateListDrawable states = FastAdapterUIUtils.getSelectableBackground(ctx, selected_color, animate);
        ColorDrawable clrPressed = new ColorDrawable(FastAdapterUIUtils.adjustAlpha(selected_color, pressed_alpha));
        states.addState(new int[]{16842919}, (Drawable)clrPressed);
        return states;
    }

    public static int adjustAlpha(@ColorInt int color, int alpha) {
        return alpha << 24 | color & 0xFFFFFF;
    }

    public static int getSelectableBackground(Context ctx) {
        TypedValue outValue = new TypedValue();
        ctx.getTheme().resolveAttribute(R.attr.selectableItemBackground, outValue, true);
        return outValue.resourceId;
    }

    public static Drawable getRippleDrawable(@ColorInt int normalColor, @ColorInt int pressedColor, int radius) {
        if (Build.VERSION.SDK_INT >= 21) {
            return new RippleDrawable(ColorStateList.valueOf((int)pressedColor), (Drawable)new ColorDrawable(normalColor), FastAdapterUIUtils.getRippleMask(normalColor, radius));
        }
        return FastAdapterUIUtils.getStateListDrawable(normalColor, pressedColor);
    }

    private static Drawable getRippleMask(int color, int radius) {
        float[] outerRadius = new float[8];
        Arrays.fill(outerRadius, (float)radius);
        RoundRectShape r = new RoundRectShape(outerRadius, null, null);
        ShapeDrawable shapeDrawable = new ShapeDrawable((Shape)r);
        shapeDrawable.getPaint().setColor(color);
        return shapeDrawable;
    }

    private static StateListDrawable getStateListDrawable(int normalColor, int pressedColor) {
        StateListDrawable states = new StateListDrawable();
        states.addState(new int[]{16842919}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16842908}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[]{16843518}, (Drawable)new ColorDrawable(pressedColor));
        states.addState(new int[0], (Drawable)new ColorDrawable(normalColor));
        return states;
    }
}

