/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin.util.parser;

import com.mikepenz.aboutlibraries.plugin.mapping.License;
import groovy.json.JsonSlurper;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001a\u0010\u0007\u001a\u0004\u0018\u00010\b2\u0006\u0010\t\u001a\u00020\u00042\u0006\u0010\n\u001a\u00020\u000bH\u0002J\u0014\u0010\f\u001a\b\u0012\u0004\u0012\u00020\b0\r2\u0006\u0010\u000e\u001a\u00020\u000fR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/util/parser/LicenseReader;", "", "()V", "LICENSES_DIR", "", "LOGGER", "Lorg/slf4j/Logger;", "readLicense", "Lcom/mikepenz/aboutlibraries/plugin/mapping/License;", "name", "content", "Ljava/io/InputStream;", "readLicenses", "", "configDir", "Ljava/io/File;", "plugin"})
@SourceDebugExtension(value={"SMAP\nLicenseReader.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseReader.kt\ncom/mikepenz/aboutlibraries/plugin/util/parser/LicenseReader\n+ 2 _Arrays.kt\nkotlin/collections/ArraysKt___ArraysKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,52:1\n11383#2,9:53\n13309#2:62\n13310#2:64\n11392#2:65\n1#3:63\n*S KotlinDebug\n*F\n+ 1 LicenseReader.kt\ncom/mikepenz/aboutlibraries/plugin/util/parser/LicenseReader\n*L\n14#1:53,9\n14#1:62\n14#1:64\n14#1:65\n14#1:63\n*E\n"})
public final class LicenseReader {
    @NotNull
    public static final LicenseReader INSTANCE = new LicenseReader();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final String LICENSES_DIR;

    private LicenseReader() {
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public final List<License> readLicenses(@NotNull File configDir) {
        List list;
        Intrinsics.checkNotNullParameter((Object)configDir, (String)"configDir");
        File licensesDir = new File(configDir, LICENSES_DIR);
        if (licensesDir.exists()) {
            File[] fileArray = licensesDir.listFiles();
            if (fileArray != null) {
                void $this$mapNotNullTo$iv$iv;
                File[] $this$mapNotNull$iv = fileArray;
                boolean $i$f$mapNotNull = false;
                File[] fileArray2 = $this$mapNotNull$iv;
                Collection destination$iv$iv = new ArrayList();
                boolean $i$f$mapNotNullTo = false;
                void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
                boolean $i$f$forEach = false;
                int n = ((void)$this$forEach$iv$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    License it$iv$iv;
                    void element$iv$iv$iv;
                    void element$iv$iv = element$iv$iv$iv = $this$forEach$iv$iv$iv[i];
                    boolean bl = false;
                    void it = element$iv$iv;
                    boolean bl2 = false;
                    String string = it.getName();
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
                    Intrinsics.checkNotNull((Object)it);
                    if (INSTANCE.readLicense(string, new FileInputStream((File)it)) == null) continue;
                    boolean bl3 = false;
                    destination$iv$iv.add(it$iv$iv);
                }
                list = (List)destination$iv$iv;
            } else {
                list = CollectionsKt.emptyList();
            }
        } else {
            LOGGER.debug("No custom licenses provided");
            list = CollectionsKt.emptyList();
        }
        return list;
    }

    private final License readLicense(String name, InputStream content) {
        License license;
        try {
            License license2;
            Object object = new JsonSlurper().parse(content);
            Intrinsics.checkNotNull((Object)object, (String)"null cannot be cast to non-null type kotlin.collections.Map<kotlin.String, kotlin.String>");
            Map c = (Map)object;
            Object v = c.get("name");
            Intrinsics.checkNotNull(v);
            License it = license2 = new License((String)v, (String)c.get("url"), (String)c.get("year"), (String)c.get("content"));
            boolean bl = false;
            it.setSpdxId((String)c.get("spdxId"));
            it.setInternalHash((String)c.get("hash"));
            license = license2;
        }
        catch (Throwable t) {
            LOGGER.error("Could not read the license (" + name + ")", t);
            license = null;
        }
        return license;
    }

    static {
        Logger logger = LoggerFactory.getLogger(LicenseReader.class);
        Intrinsics.checkNotNull((Object)logger);
        LOGGER = logger;
        LICENSES_DIR = "licenses";
    }
}

