/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin.util;

import com.mikepenz.aboutlibraries.plugin.util.LibrariesProcessor;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentIdentifier;
import org.gradle.api.artifacts.dsl.DependencyHandler;
import org.gradle.api.artifacts.query.ArtifactResolutionQuery;
import org.gradle.api.artifacts.result.ArtifactResolutionResult;
import org.gradle.api.artifacts.result.ArtifactResult;
import org.gradle.api.artifacts.result.ComponentArtifactsResult;
import org.gradle.api.artifacts.result.ResolvedArtifactResult;
import org.gradle.internal.component.external.model.DefaultModuleComponentIdentifier;
import org.gradle.maven.MavenModule;
import org.gradle.maven.MavenPomArtifact;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J0\u0010\u0005\u001a\u0004\u0018\u00010\u0006*\u00020\u00072\b\u0010\b\u001a\u0004\u0018\u00010\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\b\b\u0002\u0010\u000e\u001a\u00020\tR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000f"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/util/PomLoader;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "resolvePomFile", "Ljava/io/File;", "Lorg/gradle/api/artifacts/dsl/DependencyHandler;", "uniqueId", "", "id", "Lorg/gradle/api/artifacts/ModuleVersionIdentifier;", "parent", "", "prefix", "plugin"})
public final class PomLoader {
    @NotNull
    public static final PomLoader INSTANCE = new PomLoader();
    @NotNull
    private static final Logger LOGGER;

    private PomLoader() {
    }

    @Nullable
    public final File resolvePomFile(@NotNull DependencyHandler $this$resolvePomFile, @Nullable String uniqueId, @NotNull ModuleVersionIdentifier id, boolean parent, @NotNull String prefix) {
        Intrinsics.checkNotNullParameter((Object)$this$resolvePomFile, (String)"<this>");
        Intrinsics.checkNotNullParameter((Object)id, (String)"id");
        Intrinsics.checkNotNullParameter((Object)prefix, (String)"prefix");
        try {
            LOGGER.debug("Attempting to resolve POM file for uniqueId={}, ModuleVersionIdentifier id={}", (Object)uniqueId, (Object)id);
            Object object = new ComponentIdentifier[]{DefaultModuleComponentIdentifier.newId((ModuleVersionIdentifier)id)};
            ArtifactResolutionQuery artifactResolutionQuery = $this$resolvePomFile.createArtifactResolutionQuery().forComponents((ComponentIdentifier[])object);
            object = new Class[]{MavenPomArtifact.class};
            ArtifactResolutionResult resolutionResult = artifactResolutionQuery.withArtifacts(MavenModule.class, (Class[])object).execute();
            if (resolutionResult.getResolvedComponents().size() == 0) {
                LibrariesProcessor.Companion.getLOGGER$plugin().error(prefix + "--> Retrieved no components for: " + id);
            }
            for (ComponentArtifactsResult r : resolutionResult.getResolvedComponents()) {
                LOGGER.debug("Processing component artifact result {}", (Object)r);
                for (ArtifactResult artifact : r.getArtifacts(MavenPomArtifact.class)) {
                    LOGGER.debug("Processing artifact result {}", (Object)artifact);
                    if (!(artifact instanceof ResolvedArtifactResult)) continue;
                    if (parent) {
                        LOGGER.info(prefix + "--> Retrieved POM for: " + uniqueId + " from " + id.getGroup() + ":" + id.getName() + ":" + id.getVersion());
                    }
                    return ((ResolvedArtifactResult)artifact).getFile();
                }
            }
            return null;
        }
        catch (Exception e) {
            LOGGER.error("Could not load pom file", (Throwable)e);
            return null;
        }
    }

    public static /* synthetic */ File resolvePomFile$default(PomLoader pomLoader, DependencyHandler dependencyHandler, String string, ModuleVersionIdentifier moduleVersionIdentifier, boolean bl, String string2, int n, Object object) {
        if ((n & 8) != 0) {
            string2 = "";
        }
        return pomLoader.resolvePomFile(dependencyHandler, string, moduleVersionIdentifier, bl, string2);
    }

    static {
        Logger logger = LoggerFactory.getLogger(PomLoader.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
    }
}

