/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.plugin.util;

import com.mikepenz.aboutlibraries.plugin.mapping.License;
import com.mikepenz.aboutlibraries.plugin.mapping.SpdxLicense;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import kotlin.Metadata;
import kotlin.io.TextStreamsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00008\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0017\u0010\t\u001a\u0004\u0018\u00010\u00072\u0006\u0010\n\u001a\u00020\u0007H\u0000\u00a2\u0006\u0002\b\u000bJ&\u0010\f\u001a\u0004\u0018\u00010\r*\u0012\u0012\u0004\u0012\u00020\r0\u000ej\b\u0012\u0004\u0012\u00020\r`\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u0007J\n\u0010\u0011\u001a\u00020\u0012*\u00020\rR\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R*\u0010\u0005\u001a\u001e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u00070\u0006j\u000e\u0012\u0004\u0012\u00020\u0007\u0012\u0004\u0012\u00020\u0007`\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lcom/mikepenz/aboutlibraries/plugin/util/LicenseUtil;", "", "()V", "LOGGER", "Lorg/slf4j/Logger;", "remoteLicenseCache", "Ljava/util/HashMap;", "", "Lkotlin/collections/HashMap;", "loadLicenseCached", "url", "loadLicenseCached$plugin", "findSameSpdx", "Lcom/mikepenz/aboutlibraries/plugin/mapping/License;", "Ljava/util/HashSet;", "Lkotlin/collections/HashSet;", "spdxId", "loadSpdxLicense", "", "plugin"})
@SourceDebugExtension(value={"SMAP\nLicenseUtil.kt\nKotlin\n*S Kotlin\n*F\n+ 1 LicenseUtil.kt\ncom/mikepenz/aboutlibraries/plugin/util/LicenseUtil\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n288#2,2:64\n*S KotlinDebug\n*F\n+ 1 LicenseUtil.kt\ncom/mikepenz/aboutlibraries/plugin/util/LicenseUtil\n*L\n53#1:64,2\n*E\n"})
public final class LicenseUtil {
    @NotNull
    public static final LicenseUtil INSTANCE = new LicenseUtil();
    @NotNull
    private static final Logger LOGGER;
    @NotNull
    private static final HashMap<String, String> remoteLicenseCache;

    private LicenseUtil() {
    }

    @Nullable
    public final String loadLicenseCached$plugin(@NotNull String url) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)url, (String)"url");
        try {
            String string;
            if (remoteLicenseCache.containsKey(url)) {
                string = remoteLicenseCache.get(url);
            } else {
                ((Map)remoteLicenseCache).put(url, "");
                object = new URL(url);
                Charset charset = Charsets.UTF_8;
                byte[] byArray = TextStreamsKt.readBytes((URL)object);
                String it = new String(byArray, charset);
                boolean bl = false;
                String trimmed = StringsKt.trimIndent((String)it);
                ((Map)remoteLicenseCache).put(url, trimmed);
                string = trimmed;
            }
            object = string;
        }
        catch (Throwable t) {
            object = null;
        }
        return object;
    }

    public final void loadSpdxLicense(@NotNull License $this$loadSpdxLicense) {
        Intrinsics.checkNotNullParameter((Object)$this$loadSpdxLicense, (String)"<this>");
        String string = $this$loadSpdxLicense.getSpdxId();
        if (string == null) {
            return;
        }
        String spdxId = string;
        try {
            SpdxLicense enumLicense = SpdxLicense.Companion.find$plugin(spdxId);
            if (enumLicense != null) {
                String singleLicense;
                String licUrl = enumLicense.getTxtUrl();
                String string2 = singleLicense = this.loadLicenseCached$plugin(licUrl);
                boolean bl = string2 != null ? !StringsKt.isBlank((CharSequence)string2) : false;
                if (bl) {
                    $this$loadSpdxLicense.setName(enumLicense.getFullName());
                    $this$loadSpdxLicense.setUrl(enumLicense.getUrl());
                    $this$loadSpdxLicense.setContent(singleLicense);
                }
            } else {
                LOGGER.info("`spdxId` did not match any known SpdxLicense: " + spdxId);
            }
        }
        catch (Throwable t) {
            LOGGER.debug("Could not load the license content", t);
        }
    }

    @Nullable
    public final License findSameSpdx(@NotNull HashSet<License> $this$findSameSpdx, @Nullable String spdxId) {
        Object v0;
        block2: {
            Intrinsics.checkNotNullParameter($this$findSameSpdx, (String)"<this>");
            if (spdxId == null) {
                return null;
            }
            Iterable $this$firstOrNull$iv = $this$findSameSpdx;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                License it = (License)element$iv;
                boolean bl = false;
                if (!Intrinsics.areEqual((Object)it.getSpdxId(), (Object)spdxId)) continue;
                v0 = element$iv;
                break block2;
            }
            v0 = null;
        }
        return v0;
    }

    static {
        Logger logger = LoggerFactory.getLogger(LicenseUtil.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getLogger(...)");
        LOGGER = logger;
        remoteLicenseCache = new HashMap();
    }
}

