/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries.util;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.util.DisplayMetrics;
import android.util.TypedValue;
import android.view.View;
import androidx.core.content.ContextCompat;
import androidx.core.view.ViewCompat;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 1, 16}, bv={1, 0, 3}, k=2, d1={"\u0000\"\n\u0000\n\u0002\u0010\u0007\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a\u0014\u0010\u0000\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0003\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0004\u001a\u00020\u0001*\u00020\u00022\u0006\u0010\u0005\u001a\u00020\u0001H\u0000\u001a\u0014\u0010\u0006\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\t\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u0007H\u0000\u001a\u001c\u0010\n\u001a\u00020\u0007*\u00020\u00022\u0006\u0010\b\u001a\u00020\u00072\u0006\u0010\u000b\u001a\u00020\u0007H\u0000\u001a\u0014\u0010\f\u001a\u00020\r*\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0007H\u0000\u00a8\u0006\u0010"}, d2={"convertDpToPixel", "", "Landroid/content/Context;", "dp", "convertPixelsToDp", "px", "getThemeAttributeDimensionSize", "", "attr", "getThemeColor", "getThemeColorFromAttrOrRes", "res", "setBackground", "", "Landroid/view/View;", "drawableRes", "aboutlibraries"})
public final class UIUtilsKt {
    public static final int getThemeColor(@NotNull Context $this$getThemeColor, int attr2) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getThemeColor, (String)"$this$getThemeColor");
        TypedValue tv = new TypedValue();
        return $this$getThemeColor.getTheme().resolveAttribute(attr2, tv, true) ? (tv.resourceId != 0 ? ContextCompat.getColor((Context)$this$getThemeColor, (int)tv.resourceId) : tv.data) : 0;
    }

    public static final int getThemeColorFromAttrOrRes(@NotNull Context $this$getThemeColorFromAttrOrRes, int attr2, int res) {
        Intrinsics.checkParameterIsNotNull((Object)$this$getThemeColorFromAttrOrRes, (String)"$this$getThemeColorFromAttrOrRes");
        Integer n = UIUtilsKt.getThemeColor($this$getThemeColorFromAttrOrRes, attr2);
        boolean bl = false;
        boolean bl2 = false;
        int it = ((Number)n).intValue();
        boolean bl3 = false;
        Integer n2 = it != 0 ? n : null;
        return n2 != null ? n2 : ContextCompat.getColor((Context)$this$getThemeColorFromAttrOrRes, (int)res);
    }

    public static final void setBackground(@NotNull View $this$setBackground, int drawableRes) {
        Intrinsics.checkParameterIsNotNull((Object)$this$setBackground, (String)"$this$setBackground");
        ViewCompat.setBackground((View)$this$setBackground, (Drawable)ContextCompat.getDrawable((Context)$this$setBackground.getContext(), (int)drawableRes));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static final int getThemeAttributeDimensionSize(@NotNull Context $this$getThemeAttributeDimensionSize, int attr2) {
        int n;
        Intrinsics.checkParameterIsNotNull((Object)$this$getThemeAttributeDimensionSize, (String)"$this$getThemeAttributeDimensionSize");
        TypedArray typedArray = $this$getThemeAttributeDimensionSize.getTheme().obtainStyledAttributes(new int[]{attr2});
        boolean bl = false;
        boolean bl2 = false;
        TypedArray $this$with = typedArray;
        boolean bl3 = false;
        try {
            n = $this$with.getDimensionPixelSize(0, 0);
        }
        finally {
            $this$with.recycle();
        }
        return n;
    }

    public static final float convertDpToPixel(@NotNull Context $this$convertDpToPixel, float dp) {
        Intrinsics.checkParameterIsNotNull((Object)$this$convertDpToPixel, (String)"$this$convertDpToPixel");
        Resources resources = $this$convertDpToPixel.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return dp * ((float)metrics.densityDpi / 160.0f);
    }

    public static final float convertPixelsToDp(@NotNull Context $this$convertPixelsToDp, float px) {
        Intrinsics.checkParameterIsNotNull((Object)$this$convertPixelsToDp, (String)"$this$convertPixelsToDp");
        Resources resources = $this$convertPixelsToDp.getResources();
        Intrinsics.checkExpressionValueIsNotNull((Object)resources, (String)"resources");
        DisplayMetrics metrics = resources.getDisplayMetrics();
        return px / ((float)metrics.densityDpi / 160.0f);
    }
}

