/*
 * Decompiled with CFR 0.152.
 */
package com.mikepenz.aboutlibraries;

import android.view.View;
import android.view.animation.LayoutAnimationController;
import com.mikepenz.aboutlibraries.Libs;
import com.mikepenz.aboutlibraries.entity.Library;

public class LibsConfiguration {
    private static LibsConfiguration SINGLETON = null;
    private LibsListener listener = null;
    private LibsUIListener uiListener = null;
    private LayoutAnimationController layoutAnimationController = null;

    private LibsConfiguration() {
    }

    public static LibsConfiguration getInstance() {
        if (SINGLETON == null) {
            SINGLETON = new LibsConfiguration();
        }
        return SINGLETON;
    }

    public void setListener(LibsListener libsListener) {
        this.listener = libsListener;
    }

    public LibsListener getListener() {
        return this.listener;
    }

    public void removeListener() {
        this.listener = null;
    }

    public LibsUIListener getUiListener() {
        return this.uiListener;
    }

    public void setUiListener(LibsUIListener uiListener) {
        this.uiListener = uiListener;
    }

    public void removeUiListener() {
        this.uiListener = null;
    }

    public LayoutAnimationController getLayoutAnimationController() {
        return this.layoutAnimationController;
    }

    public void setLayoutAnimationController(LayoutAnimationController layoutAnimationController) {
        this.layoutAnimationController = layoutAnimationController;
    }

    public void reset() {
        SINGLETON = null;
    }

    public abstract class LibsListenerImpl
    implements LibsListener {
        @Override
        public void onIconClicked(View v) {
        }

        @Override
        public boolean onLibraryAuthorClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onLibraryContentClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onLibraryBottomClicked(View v, Library library) {
            return false;
        }

        @Override
        public boolean onExtraClicked(View v, Libs.SpecialButton specialButton) {
            return false;
        }

        @Override
        public boolean onIconLongClicked(View v) {
            return true;
        }

        @Override
        public boolean onLibraryAuthorLongClicked(View v, Library library) {
            return true;
        }

        @Override
        public boolean onLibraryContentLongClicked(View v, Library library) {
            return true;
        }

        @Override
        public boolean onLibraryBottomLongClicked(View v, Library library) {
            return true;
        }
    }

    public static interface LibsListener {
        public void onIconClicked(View var1);

        public boolean onLibraryAuthorClicked(View var1, Library var2);

        public boolean onLibraryContentClicked(View var1, Library var2);

        public boolean onLibraryBottomClicked(View var1, Library var2);

        public boolean onExtraClicked(View var1, Libs.SpecialButton var2);

        public boolean onIconLongClicked(View var1);

        public boolean onLibraryAuthorLongClicked(View var1, Library var2);

        public boolean onLibraryContentLongClicked(View var1, Library var2);

        public boolean onLibraryBottomLongClicked(View var1, Library var2);
    }

    public static interface LibsUIListener {
        public View preOnCreateView(View var1);

        public View postOnCreateView(View var1);
    }
}

