/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.util;

import java.util.HashMap;
import java.util.Map;

public enum Country {
    AD("Andorra", "AND", 16),
    AE("United Arab Emirates", "ARE", 784),
    AF("Afghanistan", "AFG", 4),
    AG("Antigua and Barbuda", "ATG", 28),
    AI("Anguilla", "AIA", 660),
    AL("Albania", "ALB", 8),
    AM("Armenia", "ARM", 51),
    AN("Netherlands Antilles", "ANT", 530),
    AO("Angola", "AGO", 24),
    AQ("Antarctica", "ATA", 10),
    AR("Argentina", "ARG", 32),
    AS("American Samoa", "ASM", 16),
    AT("Austria", "AUT", 40),
    AU("Australia", "AUS", 36),
    AW("Aruba", "ABW", 533),
    AX("\u212bland Islands", "ALA", 248),
    AZ("Azerbaijan", "AZE", 31),
    BA("Bosnia and Herzegovina", "BIH", 70),
    BB("Barbados", "BRB", 52),
    BD("Bangladesh", "BGD", 50),
    BE("Belgium", "BEL", 56),
    BF("Burkina Faso", "BFA", 854),
    BG("Bulgaria", "BGR", 100),
    BH("Bahrain", "BHR", 48),
    BI("Burundi", "BDI", 108),
    BJ("Benin", "BEN", 204),
    BL("Saint Barth\u00e9lemy", "BLM", 652),
    BM("Bermuda", "BMU", 60),
    BN("Brunei Darussalam", "BRN", 96),
    BO("Plurinational State of Bolivia", "BOL", 68),
    BQ("Bonaire, Sint Eustatius and Saba", "BES", 535),
    BR("Brazil", "BRA", 76),
    BS("Bahamas", "BHS", 44),
    BT("Bhutan", "BTN", 64),
    BV("Bouvet Island", "BVT", 74),
    BW("Botswana", "BWA", 72),
    BY("Belarus", "BLR", 112),
    BZ("Belize", "BLZ", 84),
    CA("Canada", "CAN", 124),
    CC("Cocos Islands", "CCK", 166),
    CD("The Democratic Republic of the Congo", "COD", 180),
    CF("Central African Republic", "CAF", 140),
    CG("Congo", "COG", 178),
    CH("Switzerland", "CHE", 756),
    CI("C\u00f4te d'Ivoire", "CIV", 384),
    CK("Cook Islands", "COK", 184),
    CL("Chile", "CHL", 152),
    CM("Cameroon", "CMR", 120),
    CN("China", "CHN", 156),
    CO("Colombia", "COL", 170),
    CR("Costa Rica", "CRI", 188),
    CU("Cuba", "CUB", 192),
    CV("Cape Verde", "CPV", 132),
    CW("Cura/u00E7ao", "CUW", 531),
    CX("Christmas Island", "CXR", 162),
    CY("Cyprus", "CYP", 196),
    CZ("Czech Republic", "CZE", 203),
    DE("Germany", "DEU", 276),
    DJ("Djibouti", "DJI", 262),
    DK("Denmark", "DNK", 208),
    DM("Dominica", "DMA", 212),
    DO("Dominican Republic", "DOM", 214),
    DZ("Algeria", "DZA", 12),
    EC("Ecuador", "ECU", 218),
    EE("Estonia", "EST", 233),
    EG("Egypt", "EGY", 818),
    EH("Western Sahara", "ESH", 732),
    ER("Eritrea", "ERI", 232),
    ES("Spain", "ESP", 724),
    ET("Ethiopia", "ETH", 231),
    FI("Finland", "FIN", 246),
    FJ("Fiji", "FJI", 242),
    FK("Falkland Islands", "FLK", 238),
    FM("Federated States of Micronesia", "FSM", 583),
    FO("Faroe Islands", "FRO", 234),
    FR("France", "FRA", 250),
    GA("Gabon", "GAB", 266),
    GB("United Kingdom", "GBR", 826),
    GD("Grenada", "GRD", 308),
    GE("Georgia", "GEO", 268),
    GF("French Guiana", "GUF", 254),
    GG("Guemsey", "GGY", 831),
    GH("Ghana", "GHA", 288),
    GI("Gibraltar", "GIB", 292),
    GL("Greenland", "GRL", 304),
    GM("Gambia", "GMB", 270),
    GN("Guinea", "GIN", 324),
    GP("Guadeloupe", "GLP", 312),
    GQ("Equatorial Guinea", "GNQ", 226),
    GR("Greece", "GRC", 300),
    GS("South Georgia and the South Sandwich Islands", "SGS", 239),
    GT("Guatemala", "GTM", 320),
    GU("Guam", "GUM", 316),
    GW("Guinea-Bissau", "GNB", 624),
    GY("Guyana", "GUY", 328),
    HK("Hong Kong", "HKG", 344),
    HM("Heard Island and McDonald Islands", "HMD", 334),
    HN("Honduras", "HND", 340),
    HR("Croatia", "HRV", 191),
    HT("Haiti", "HTI", 332),
    HU("Hungary", "HUN", 348),
    ID("Indonesia", "IDN", 360),
    IE("Ireland", "IRL", 372),
    IL("Israel", "ISR", 376),
    IM("Isle of Man", "IMN", 833),
    IN("India", "IND", 356),
    IO("British Indian Ocean Territory", "IOT", 86),
    IQ("Iraq", "IRQ", 368),
    IR("Islamic Republic of Iran", "IRN", 364),
    IS("Iceland", "ISL", 352),
    IT("Italy", "ITA", 380),
    JE("Jersey", "JEY", 832),
    JM("Jamaica", "JAM", 388),
    JO("Jordan", "JOR", 400),
    JP("Japan", "JPN", 392),
    KE("Kenya", "KEN", 404),
    KG("Kyrgyzstan", "KGZ", 417),
    KH("Cambodia", "KHM", 116),
    KI("Kiribati", "KIR", 296),
    KM("Comoros", "COM", 174),
    KN("Saint Kitts and Nevis", "KNA", 659),
    KP("Democratic People's Republic of Korea", "PRK", 408),
    KR("Republic of Korea", "KOR", 410),
    KW("Kuwait", "KWT", 414),
    KY("Cayman Islands", "CYM", 136),
    KZ("Kazakhstan", "KAZ", 398),
    LA("Lao People's Democratic Republic", "LAO", 418),
    LB("Lebanon", "LBN", 422),
    LC("Saint Lucia", "LCA", 662),
    LI("Liechtenstein", "LIE", 438),
    LK("Sri Lanka", "LKA", 144),
    LR("Liberia", "LBR", 430),
    LS("Lesotho", "LSO", 426),
    LT("Lithuania", "LTU", 440),
    LU("Luxembourg", "LUX", 442),
    LV("Latvia", "LVA", 428),
    LY("Libya", "LBY", 434),
    MA("Morocco", "MAR", 504),
    MC("Monaco", "MCO", 492),
    MD("Republic of Moldova", "MDA", 498),
    ME("Montenegro", "MNE", 499),
    MF("Saint Martin", "MAF", 663),
    MG("Madagascar", "MDG", 450),
    MH("Marshall Islands", "MHL", 584),
    MK("The former Yugoslav Republic of Macedonia", "MKD", 807),
    ML("Mali", "MLI", 466),
    MM("Myanmar", "MMR", 104),
    MN("Mongolia", "MNG", 496),
    MO("Macao", "MCO", 492),
    MP("Northern Mariana Islands", "MNP", 580),
    MQ("Martinique", "MTQ", 474),
    MR("Mauritania", "MRT", 478),
    MS("Montserrat", "MSR", 500),
    MT("Malta", "MLT", 470),
    MU("Mauritius", "MUS", 480),
    MV("Maldives", "MDV", 462),
    MW("Malawi", "MWI", 454),
    MX("Mexico", "MEX", 484),
    MY("Malaysia", "MYS", 458),
    MZ("Mozambique", "MOZ", 508),
    NA("Namibia", "NAM", 516),
    NC("New Caledonia", "NCL", 540),
    NE("Niger", "NER", 562),
    NF("Norfolk Island", "NFK", 574),
    NG("Nigeria", "NGA", 566),
    NI("Nicaragua", "NIC", 558),
    NL("Netherlands", "NLD", 528),
    NO("Norway", "NOR", 578),
    NP("Nepal", "NPL", 524),
    NR("Nauru", "NRU", 520),
    NU("Niue", "NIU", 570),
    NZ("New Zealand", "NZL", 554),
    OM("Oman", "OMN", 512),
    PA("Panama", "PAN", 591),
    PE("Peru", "PER", 604),
    PF("French Polynesia", "PYF", 258),
    PG("Papua New Guinea", "PNG", 598),
    PH("Philippines", "PHL", 608),
    PK("Pakistan", "PAK", 586),
    PL("Poland", "POL", 616),
    PM("Saint Pierre and Miquelon", "SPM", 666),
    PN("Pitcairn", "PCN", 612),
    PR("Puerto Rico", "PRI", 630),
    PS("Occupied Palestinian Territory", "PSE", 275),
    PT("Portugal", "PRT", 620),
    PW("Palau", "PLW", 585),
    PY("Paraguay", "PRY", 600),
    QA("Qatar", "QAT", 634),
    RE("R\u00e9union", "REU", 638),
    RO("Romania", "ROU", 642),
    RS("Serbia", "SRB", 688),
    RU("Russian Federation", "RUS", 643),
    RW("Rwanda", "RWA", 646),
    SA("Saudi Arabia", "SAU", 682),
    SB("Solomon Islands", "SLB", 90),
    SC("Seychelles", "SYC", 690),
    SD("Sudan", "SDN", 729),
    SE("Sweden", "SWE", 752),
    SG("Singapore", "SGP", 702),
    SH("Saint Helena, Ascension and Tristan da Cunha", "SHN", 654),
    SI("Slovenia", "SVN", 705),
    SJ("Svalbard and Jan Mayen", "SJM", 744),
    SK("Slovakia", "SVK", 703),
    SL("Sierra Leone", "SLE", 694),
    SM("San Marino", "SMR", 674),
    SN("Senegal", "SEN", 686),
    SO("Somalia", "SOM", 706),
    SR("Suriname", "SUR", 740),
    SS("South Sudan", "SSD", 728),
    ST("Sao Tome and Principe", "STP", 678),
    SV("El Salvador", "SLV", 222),
    SX("Sint Maarten", "SXM", 534),
    SY("Syrian Arab Republic", "SYR", 760),
    SZ("Swaziland", "SWZ", 748),
    TC("Turks and Caicos Islands", "TCA", 796),
    TD("Chad", "TCD", 148),
    TF("French Southern Territories", "ATF", 260),
    TG("Togo", "TGO", 768),
    TH("Thailand", "THA", 764),
    TJ("Tajikistan", "TJK", 762),
    TK("Tokelau", "TKL", 772),
    TL("Timor-Leste", "TLS", 626),
    TM("Turkmenistan", "TKM", 795),
    TN("Tunisia", "TUN", 788),
    TO("Tonga", "TON", 776),
    TR("Turkey", "TUR", 792),
    TT("Trinidad and Tobago", "TTO", 780),
    TV("Tuvalu", "TUV", 798),
    TW("Taiwan, Province of China", "TWN", 158),
    TZ("United Republic of Tanzania", "TZA", 834),
    UA("Ukraine", "UKR", 804),
    UG("Uganda", "UGA", 800),
    UM("United States Minor Outlying Islands", "UMI", 581),
    US("United States", "USA", 840),
    UY("Uruguay", "URY", 858),
    UZ("Uzbekistan", "UZB", 860),
    VA("Holy See", "VAT", 336),
    VC("Saint Vincent and the Grenadines", "VCT", 670),
    VE("Bolivarian Republic of Venezuela", "VEN", 862),
    VG("British Virgin Islands", "VGB", 92),
    VI("Virgin Islands, U.S.", "VIR", 850),
    VN("Viet Nam", "VNM", 704),
    VU("Vanuatu", "VUT", 548),
    WF("Wallis and Futuna", "WLF", 876),
    WS("Samoa", "WSM", 882),
    YE("Yemen", "YEM", 887),
    YT("Mayotte", "MYT", 175),
    ZA("South Africa", "ZAF", 710),
    ZM("Zambia", "ZMB", 894),
    ZW("Zimbabwe", "ZWE", 716);

    private static final Map<String, Country> alpha3Map;
    private static final Map<Integer, Country> numericMap;
    private final String name;
    private final String alpha3;
    private final int numeric;

    private Country(String name, String alpha3, int numeric) {
        this.name = name;
        this.alpha3 = alpha3;
        this.numeric = numeric;
    }

    public String getName() {
        return this.name;
    }

    public String getAlpha2() {
        return this.name();
    }

    public String getAlpha3() {
        return this.alpha3;
    }

    public int getNumeric() {
        return this.numeric;
    }

    public static Country getByCode(String code) {
        if (code == null) {
            return null;
        }
        switch (code.length()) {
            case 2: {
                return Country.getByAlpha2Code(code);
            }
            case 3: {
                return Country.getByAlpha3Code(code);
            }
        }
        return null;
    }

    private static Country getByAlpha2Code(String code) {
        try {
            return Enum.valueOf(Country.class, code);
        }
        catch (IllegalArgumentException e) {
            return null;
        }
    }

    private static Country getByAlpha3Code(String code) {
        return alpha3Map.get(code);
    }

    public static Country getByCode(int code) {
        return numericMap.get(code);
    }

    static {
        alpha3Map = new HashMap<String, Country>();
        numericMap = new HashMap<Integer, Country>();
        for (Country cc : Country.values()) {
            alpha3Map.put(cc.getAlpha3(), cc);
            numericMap.put(cc.getNumeric(), cc);
        }
    }
}

