/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.core.Order;
import com.miguelangeljulvez.easyredsys.client.util.Currency;
import com.miguelangeljulvez.easyredsys.client.util.Language;
import com.miguelangeljulvez.easyredsys.client.util.PaymentMethod;
import com.miguelangeljulvez.easyredsys.client.util.TransactionType;

public final class OrderCES
extends Order {
    protected OrderCES() {
        this.apiMacSha256.setParameter("DS_MERCHANT_MERCHANTURL", "");
        this.apiMacSha256.setParameter("DS_MERCHANT_URLOK", "");
        this.apiMacSha256.setParameter("DS_MERCHANT_URLKO", "");
        this.apiMacSha256.setParameter("DS_MERCHANT_MERCHANTNAME", "");
        this.apiMacSha256.setParameter("DS_MERCHANT_CONSUMERLANGUAGE", "");
        this.apiMacSha256.setParameter("DS_MERCHANT_PAYMETHODS", "");
    }

    public String getDs_merchant_merchantURL() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_MERCHANTURL");
    }

    public void setDs_merchant_merchantURL(String ds_merchant_merchantURL) {
        this.apiMacSha256.setParameter("DS_MERCHANT_MERCHANTURL", ds_merchant_merchantURL);
    }

    public String getDs_merchant_UrlOK() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_URLOK");
    }

    public void setDs_merchant_UrlOK(String ds_merchant_UrlOK) {
        this.apiMacSha256.setParameter("DS_MERCHANT_URLOK", ds_merchant_UrlOK);
    }

    public String getDs_merchant_UrlKO() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_URLKO");
    }

    public void setDs_merchant_UrlKO(String ds_merchant_UrlKO) {
        this.apiMacSha256.setParameter("DS_MERCHANT_URLKO", ds_merchant_UrlKO);
    }

    public String getDs_merchant_merchantName() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_MERCHANTNAME");
    }

    public void setDs_merchant_merchantName(String ds_merchant_merchantName) {
        this.apiMacSha256.setParameter("DS_MERCHANT_MERCHANTNAME", ds_merchant_merchantName);
    }

    public int getDs_merchant_consumerLanguage() {
        try {
            return Integer.valueOf(this.apiMacSha256.getParameter("DS_MERCHANT_CONSUMERLANGUAGE"));
        }
        catch (NumberFormatException numberFormatException) {
            return 0;
        }
    }

    public void setDs_merchant_consumerLanguage(int ds_merchant_consumerLanguage) {
        this.apiMacSha256.setParameter("DS_MERCHANT_CONSUMERLANGUAGE", String.valueOf(ds_merchant_consumerLanguage));
    }

    public String getDs_merchant_paymethods() {
        return this.apiMacSha256.getParameter("DS_MERCHANT_PAYMETHODS");
    }

    public void setDs_merchant_paymethods(String ds_merchant_paymethods) {
        this.apiMacSha256.setParameter("DS_MERCHANT_PAYMETHODS", ds_merchant_paymethods);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("DS_MERCHANT_MERCHANTURL:");
        sb.append(this.getDs_merchant_merchantURL());
        sb.append(System.lineSeparator());
        sb.append("DS_MERCHANT_URLOK:");
        sb.append(this.getDs_merchant_UrlOK());
        sb.append(System.lineSeparator());
        sb.append("DS_MERCHANT_URLKO:");
        sb.append(this.getDs_merchant_UrlKO());
        sb.append(System.lineSeparator());
        sb.append("DS_MERCHANT_MERCHANTNAME:");
        sb.append(this.getDs_merchant_merchantName());
        sb.append(System.lineSeparator());
        sb.append("DS_MERCHANT_CONSUMER_LANGUAGE:");
        sb.append(this.getDs_merchant_consumerLanguage());
        sb.append(System.lineSeparator());
        return sb.toString();
    }

    public static class Builder {
        private String transactionType;
        private long currency;
        private int consumerLanguage;
        private String order;
        private long amount;
        private String urlOk;
        private String urlKo;
        private String urlNotification;
        private String productDescription;
        private String payMethods;
        private AppConfig appConfig;

        public Builder(Class<? extends AppConfig> userActionClass) {
            try {
                this.appConfig = userActionClass.newInstance();
            }
            catch (IllegalAccessException | InstantiationException e) {
                e.printStackTrace();
            }
        }

        public Builder(AppConfig userActionClass) {
            this.appConfig = userActionClass;
        }

        public Builder transactionType(TransactionType transactionType) {
            this.transactionType = transactionType.getCode();
            return this;
        }

        public Builder currency(Currency currency) {
            this.currency = currency.getISOCodeNumeric();
            return this;
        }

        public Builder consumerLanguage(Language consumerLanguage) {
            this.consumerLanguage = Integer.parseInt(consumerLanguage.getCode());
            return this;
        }

        public Builder order(String order) {
            this.order = order;
            return this;
        }

        public Builder amount(long amount) {
            this.amount = amount;
            return this;
        }

        public Builder urlOk(String urlOk) {
            this.urlOk = urlOk;
            return this;
        }

        public Builder urlKo(String urlKo) {
            this.urlKo = urlKo;
            return this;
        }

        public Builder urlNotification(String urlNotification) {
            this.urlNotification = urlNotification;
            return this;
        }

        public Builder productDescription(String productDescription) {
            this.productDescription = productDescription;
            return this;
        }

        public Builder payMethods(PaymentMethod paymentMethods) {
            this.payMethods = paymentMethods.getCode();
            return this;
        }

        public OrderCES build() {
            OrderCES orderCES = new OrderCES();
            orderCES.setDs_merchant_merchantcode(Long.parseLong(this.appConfig.getMerchantCode()));
            orderCES.setDs_merchant_terminal(Long.parseLong(this.appConfig.getTerminal()));
            orderCES.setDs_merchant_transactiontype(this.transactionType);
            orderCES.setDs_merchant_currency(this.currency);
            orderCES.setDs_merchant_consumerLanguage(this.consumerLanguage);
            orderCES.setDs_merchant_order(this.order);
            orderCES.setDs_merchant_amount(this.amount);
            orderCES.setDs_merchant_merchantURL(this.urlNotification);
            orderCES.setDs_merchant_UrlOK(this.urlOk);
            orderCES.setDs_merchant_UrlKO(this.urlKo);
            orderCES.setDs_merchant_productdescription(this.productDescription);
            orderCES.setDs_merchant_paymethods(this.payMethods);
            orderCES.setAppConfig(this.appConfig);
            return orderCES;
        }
    }
}

