/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.core.Notification;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.annotation.XmlElement;
import org.json.JSONException;
import sis.redsys.api.ApiWsMacSha256;

public final class NotificationNoCES
extends Notification {
    private static final Logger _log = Logger.getLogger(NotificationNoCES.class.getName());

    @Override
    public boolean isValid(String claveSecreta, String expectedSignature) {
        String signature = "";
        try {
            ApiWsMacSha256 apiWsMacSha256 = new ApiWsMacSha256();
            signature = apiWsMacSha256.createSignatureResponseHostToHost(claveSecreta, this.getCadenaConcatenada(), this.getDs_Order());
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return !signature.isEmpty() && signature.equals(expectedSignature);
    }

    private String getCadenaConcatenada() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDs_Amount());
        sb.append(this.getDs_Order());
        sb.append(this.getDs_MerchantCode());
        sb.append(this.getDs_Currency());
        sb.append(this.getDs_Response());
        sb.append(this.getDs_CardNumber());
        sb.append(this.getDs_TransactionType());
        sb.append(this.getDs_SecurePayment());
        return sb.toString();
    }

    @XmlElement(name="Ds_CardNumber")
    public String getDs_CardNumber() {
        String ds_cardNumber = "";
        try {
            ds_cardNumber = this.apiMacSha256.getParameter("Ds_CardNumber");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ds_cardNumber;
    }

    public void setDs_CardNumber(String ds_cardNumber) {
        this.apiMacSha256.setParameter("Ds_CardNumber", ds_cardNumber);
    }

    @Override
    @XmlElement(name="Ds_MerchantData")
    public String getDs_MerchantData() {
        String ds_MerchantData = "";
        try {
            ds_MerchantData = this.apiMacSha256.getParameter("Ds_MerchantData");
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return ds_MerchantData;
    }

    @Override
    public void setDs_MerchantData(String ds_MerchantData) {
        this.apiMacSha256.setParameter("Ds_MerchantData", ds_MerchantData);
    }

    @Override
    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append(super.toString());
        sb.append("Ds_CardNumber:");
        sb.append(this.getDs_CardNumber());
        sb.append(System.lineSeparator());
        return sb.toString();
    }
}

