/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.core.OrderNoCES;
import com.miguelangeljulvez.easyredsys.client.util.EasyredsysUtil;
import com.miguelangeljulvez.easyredsys.client.util.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import sis.redsys.api.ApiWsMacSha256;

@XmlRootElement(name="REQUEST")
public class MessageOrderNoCESRequest {
    private final ApiWsMacSha256 apiWsMacSha256 = new ApiWsMacSha256();
    private OrderNoCES orderNoCES;
    private static final Logger _log = Logger.getLogger(MessageOrderNoCESRequest.class.getName());

    private MessageOrderNoCESRequest() {
    }

    @XmlElement(name="DS_SIGNATUREVERSION")
    public String getDs_SignatureVersion() {
        return this.orderNoCES.getDs_SignatureVersion();
    }

    @XmlElement(name="DS_SIGNATURE")
    public String getDs_Signature() {
        String ds_signature = "";
        try {
            ds_signature = this.apiWsMacSha256.createMerchantSignatureHostToHost(EasyredsysUtil.getSecretyKey(this.orderNoCES), XMLUtil.toRedsysXML(this.orderNoCES));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return ds_signature;
    }

    @XmlAnyElement(lax=true)
    public OrderNoCES getOrderNoCES() {
        return this.orderNoCES;
    }

    public void setOrderNoCES(OrderNoCES orderNoCES) {
        this.orderNoCES = orderNoCES;
    }

    @XmlTransient
    public String getRedsysUrl() {
        return EasyredsysUtil.getWebserviceURL(this.orderNoCES.getAppConfig().isTestMode());
    }

    public static class Builder {
        private OrderNoCES orderNoCES;

        public Builder(OrderNoCES orderNoCES) {
            this.orderNoCES = orderNoCES;
        }

        public MessageOrderNoCESRequest build() {
            MessageOrderNoCESRequest messageOrderNoCESRequest = new MessageOrderNoCESRequest();
            messageOrderNoCESRequest.setOrderNoCES(this.orderNoCES);
            return messageOrderNoCESRequest;
        }
    }
}

