/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.util;

import java.util.HashMap;
import java.util.Locale;
import java.util.ResourceBundle;

public class ResponseCodes {
    private static final HashMap<String, String> errorResponseCodes = new HashMap();
    private static final HashMap<String, String> successResponseCodes = new HashMap();

    private ResponseCodes() {
    }

    public static String getErrorResponseMessage(String responseCode) {
        return ResponseCodes.getErrorResponseMessage(responseCode, Locale.getDefault());
    }

    public static String getErrorResponseMessage(String responseCode, Locale locale) {
        String message = errorResponseCodes.get(responseCode);
        if (message == null) {
            message = "not-response-code-found";
        }
        return ResourceBundle.getBundle("Language", locale).getString(message);
    }

    public static String getSuccessResponseMessage(String responseCode) {
        return ResponseCodes.getSuccessResponseMessage(responseCode, Locale.getDefault());
    }

    public static String getSuccessResponseMessage(String responseCode, Locale locale) {
        String message = successResponseCodes.get(responseCode);
        if (message == null) {
            message = "not-response-code-found";
        }
        return ResourceBundle.getBundle("Language", locale).getString(message);
    }

    public static boolean isErrorResponse(String responseCode) {
        return errorResponseCodes.containsKey(responseCode);
    }

    public static boolean isSuccessResponse(String responseCode) {
        return successResponseCodes.containsKey(responseCode);
    }

    static {
        for (int i = 0; i < 100; ++i) {
            String number = String.valueOf(i);
            while (number.length() < 4) {
                number = "0" + number;
            }
            successResponseCodes.put(number, number);
        }
        successResponseCodes.put("0900", "0900");
        successResponseCodes.put("400", "400");
        errorResponseCodes.put("101", "101");
        errorResponseCodes.put("102", "106");
        errorResponseCodes.put("125", "125");
        errorResponseCodes.put("129", "129");
        errorResponseCodes.put("180", "180");
        errorResponseCodes.put("184", "184");
        errorResponseCodes.put("190", "190");
        errorResponseCodes.put("191", "191");
        errorResponseCodes.put("202", "202");
        errorResponseCodes.put("904", "904");
        errorResponseCodes.put("909", "909");
        errorResponseCodes.put("913", "913");
        errorResponseCodes.put("944", "944");
        errorResponseCodes.put("950", "950");
        errorResponseCodes.put("912", "912");
        errorResponseCodes.put("9912", "9912");
        errorResponseCodes.put("9064", "9064");
        errorResponseCodes.put("9078", "9078");
        errorResponseCodes.put("9093", "9093");
        errorResponseCodes.put("9094", "9094");
        errorResponseCodes.put("9104", "9104");
        errorResponseCodes.put("9218", "9218");
        errorResponseCodes.put("9253", "9253");
        errorResponseCodes.put("9256", "9256");
        errorResponseCodes.put("9257", "9257");
        errorResponseCodes.put("9261", "9261");
        errorResponseCodes.put("9913", "9913");
        errorResponseCodes.put("9914", "9914");
        errorResponseCodes.put("9915", "9915");
        errorResponseCodes.put("9928", "9928");
        errorResponseCodes.put("9929", "9929");
        errorResponseCodes.put("9997", "9997");
        errorResponseCodes.put("9998", "9998");
        errorResponseCodes.put("9999", "9999");
    }
}

