/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.core.Notification;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import sis.redsys.api.ApiWsMacSha256;

public final class NotificationNoCES
extends Notification {
    private static final Logger _log = Logger.getLogger(NotificationNoCES.class.getName());

    @Override
    public boolean isValid(String claveSecreta, String expectedSignature) {
        String signature = "";
        try {
            ApiWsMacSha256 apiWsMacSha256 = new ApiWsMacSha256();
            signature = apiWsMacSha256.createSignatureResponseHostToHost(claveSecreta, this.getCadenaConcatenada(), this.getDs_Order());
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return !signature.isEmpty() && signature.equals(expectedSignature);
    }

    private String getCadenaConcatenada() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getDs_Amount());
        sb.append(this.getDs_Order());
        sb.append(this.getDs_MerchantCode());
        sb.append(this.getDs_Currency());
        sb.append(this.getDs_Response());
        sb.append(this.getDs_TransactionType());
        sb.append(this.getDs_SecurePayment());
        return sb.toString();
    }
}

