/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.core.OrderNoCES;
import com.miguelangeljulvez.easyredsys.client.util.RedsysAddresses;
import com.miguelangeljulvez.easyredsys.client.util.XMLUtil;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;
import javax.xml.bind.annotation.XmlAnyElement;
import javax.xml.bind.annotation.XmlElement;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import sis.redsys.api.ApiWsMacSha256;

@XmlRootElement(name="REQUEST")
public class MessageOrderNoCESRequest {
    private final ApiWsMacSha256 apiWsMacSha256 = new ApiWsMacSha256();
    private volatile String claveSecreta;
    private volatile boolean testMode = true;
    private OrderNoCES orderNoCES;
    private static final Logger _log = Logger.getLogger(MessageOrderNoCESRequest.class.getName());

    public MessageOrderNoCESRequest(OrderNoCES orderNoCES, String claveSecreta) {
        this.orderNoCES = orderNoCES;
        this.claveSecreta = claveSecreta;
    }

    public MessageOrderNoCESRequest() {
    }

    @XmlElement(name="DS_SIGNATUREVERSION")
    public String getDs_SignatureVersion() {
        return this.orderNoCES.getDs_SignatureVersion();
    }

    @XmlElement(name="DS_SIGNATURE")
    public String getDs_Signature() {
        String ds_signature = "";
        try {
            ds_signature = this.apiWsMacSha256.createMerchantSignatureHostToHost(this.claveSecreta, XMLUtil.toRedsysXML(this.orderNoCES));
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return ds_signature;
    }

    @XmlAnyElement(lax=true)
    public OrderNoCES getOrderNoCES() {
        return this.orderNoCES;
    }

    public void setOrderNoCES(OrderNoCES orderNoCES) {
        this.orderNoCES = orderNoCES;
    }

    @XmlTransient
    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    @XmlTransient
    public String getRedsysUrl() {
        if (this.testMode) {
            return RedsysAddresses.getWebserviceURL("test");
        }
        return RedsysAddresses.getWebserviceURL("pro");
    }

    @XmlTransient
    public String getClaveSecreta() {
        return this.claveSecreta;
    }

    public void setClaveSecreta(String claveSecreta) {
        this.claveSecreta = claveSecreta;
    }

    public static class Builder {
        private OrderNoCES orderNoCES;
        private String claveSecreta;
        private boolean testMode;

        public Builder() {
        }

        public Builder(Class<? extends AppConfig> userActionClass) {
            try {
                Method isTestMode = userActionClass.getDeclaredMethod("isTestMode", new Class[0]);
                isTestMode.setAccessible(true);
                Method getSecretKey = userActionClass.getDeclaredMethod("getSecretKey", new Class[0]);
                getSecretKey.setAccessible(true);
                this.testMode = (Boolean)isTestMode.invoke(null, new Object[0]);
                this.claveSecreta = !this.testMode ? (String)getSecretKey.invoke(null, new Object[0]) : "sq7HjrUOBfKmC576ILgskD5srU870gJ7";
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public Builder withOrder(OrderNoCES orderNoCES) {
            this.orderNoCES = orderNoCES;
            return this;
        }

        public Builder secretKey(String claveSecreta) {
            this.claveSecreta = claveSecreta;
            return this;
        }

        public Builder testMode(boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public MessageOrderNoCESRequest build() {
            MessageOrderNoCESRequest messageOrderNoCESRequest = new MessageOrderNoCESRequest();
            messageOrderNoCESRequest.setClaveSecreta(this.claveSecreta);
            messageOrderNoCESRequest.setOrderNoCES(this.orderNoCES);
            messageOrderNoCESRequest.setTestMode(this.testMode);
            return messageOrderNoCESRequest;
        }
    }
}

