/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.core.NotificationCES;
import java.io.UnsupportedEncodingException;
import java.util.logging.Level;
import java.util.logging.Logger;

public final class MessageOrderCESResponse {
    private volatile String claveSecreta;
    private String ds_SignatureVersion;
    private String ds_Signature;
    private String ds_MerchantParameters;
    private NotificationCES operationCES;
    private static final Logger _log = Logger.getLogger(MessageOrderCESResponse.class.getName());

    public MessageOrderCESResponse(String ds_SignatureVersion, String ds_Signature, String ds_MerchantParameters, String claveSecreta) {
        this.ds_SignatureVersion = ds_SignatureVersion;
        this.ds_Signature = ds_Signature;
        this.ds_MerchantParameters = ds_MerchantParameters;
        this.claveSecreta = claveSecreta;
        this.operationCES = new NotificationCES();
        try {
            this.operationCES.getApiMacSha256().decodeMerchantParameters(ds_MerchantParameters);
            this.operationCES.setDs_MerchantParameters(ds_MerchantParameters);
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
    }

    public MessageOrderCESResponse() {
    }

    public NotificationCES getOperationCES() {
        return this.operationCES;
    }

    public void setOperationCES(NotificationCES operationCES) {
        this.operationCES = operationCES;
    }

    public boolean isValid() {
        return this.operationCES.isValid(this.claveSecreta, this.ds_Signature);
    }

    public String getDs_SignatureVersion() {
        return this.ds_SignatureVersion;
    }

    public void setDs_SignatureVersion(String ds_SignatureVersion) {
        this.ds_SignatureVersion = ds_SignatureVersion;
    }

    public String getDs_Signature() {
        return this.ds_Signature;
    }

    public void setDs_Signature(String ds_Signature) {
        this.ds_Signature = ds_Signature;
    }

    public String getDs_MerchantParameters() {
        return this.ds_MerchantParameters;
    }

    public void setDs_MerchantParameters(String ds_MerchantParameters) {
        this.ds_MerchantParameters = ds_MerchantParameters;
    }

    public String getClaveSecreta() {
        return this.claveSecreta;
    }

    public void setClaveSecreta(String claveSecreta) {
        this.claveSecreta = claveSecreta;
    }
}

