/*
 * Decompiled with CFR 0.152.
 */
package com.miguelangeljulvez.easyredsys.client.core;

import com.miguelangeljulvez.easyredsys.client.AppConfig;
import com.miguelangeljulvez.easyredsys.client.core.OrderCES;
import com.miguelangeljulvez.easyredsys.client.util.RedsysAddresses;
import java.io.UnsupportedEncodingException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public class MessageOrderCESRequest {
    private volatile String claveSecreta;
    private volatile boolean testMode = true;
    private OrderCES orderCES;
    private static final Logger _log = Logger.getLogger(MessageOrderCESRequest.class.getName());

    public MessageOrderCESRequest(OrderCES orderCES, String claveSecreta) {
        this.orderCES = orderCES;
        this.claveSecreta = claveSecreta;
    }

    public MessageOrderCESRequest() {
    }

    public String getDs_MerchantParameters() {
        String merchanParameters = "";
        try {
            merchanParameters = this.orderCES.apiMacSha256.createMerchantParameters();
        }
        catch (UnsupportedEncodingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return merchanParameters;
    }

    public String getDs_Signature() {
        String dsSignature = "";
        try {
            dsSignature = this.orderCES.apiMacSha256.createMerchantSignature(this.claveSecreta);
        }
        catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
            _log.log(Level.WARNING, e.getMessage(), e);
        }
        return dsSignature;
    }

    public String getDs_SignatureVersion() {
        return this.orderCES.getDs_SignatureVersion();
    }

    public OrderCES getOrderCES() {
        return this.orderCES;
    }

    public void setOrderCES(OrderCES orderCES) {
        this.orderCES = orderCES;
    }

    public boolean isTestMode() {
        return this.testMode;
    }

    public void setTestMode(boolean testMode) {
        this.testMode = testMode;
    }

    public String getRedsysUrl() {
        if (this.testMode) {
            return RedsysAddresses.getRedirectURL("test");
        }
        return RedsysAddresses.getRedirectURL("pro");
    }

    public String getClaveSecreta() {
        return this.claveSecreta;
    }

    public void setClaveSecreta(String claveSecreta) {
        this.claveSecreta = claveSecreta;
    }

    public static class Builder {
        private OrderCES orderCES;
        private String claveSecreta;
        private boolean testMode;

        public Builder() {
        }

        public Builder(Class<? extends AppConfig> userActionClass) {
            try {
                Method isTestMode = userActionClass.getDeclaredMethod("isTestMode", new Class[0]);
                isTestMode.setAccessible(true);
                Method getSecretKey = userActionClass.getDeclaredMethod("getSecretKey", new Class[0]);
                getSecretKey.setAccessible(true);
                this.testMode = (Boolean)isTestMode.invoke(null, new Object[0]);
                this.claveSecreta = !this.testMode ? (String)getSecretKey.invoke(null, new Object[0]) : "sq7HjrUOBfKmC576ILgskD5srU870gJ7";
            }
            catch (NoSuchMethodException e) {
                e.printStackTrace();
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
        }

        public Builder withOrder(OrderCES orderCES) {
            this.orderCES = orderCES;
            return this;
        }

        public Builder secretKey(String claveSecreta) {
            this.claveSecreta = claveSecreta;
            return this;
        }

        public Builder testMode(boolean testMode) {
            this.testMode = testMode;
            return this;
        }

        public MessageOrderCESRequest build() {
            MessageOrderCESRequest messageOrderCESRequest = new MessageOrderCESRequest();
            messageOrderCESRequest.setClaveSecreta(this.claveSecreta);
            messageOrderCESRequest.setOrderCES(this.orderCES);
            messageOrderCESRequest.setTestMode(this.testMode);
            return messageOrderCESRequest;
        }
    }
}

