/*
 * Decompiled with CFR 0.152.
 */
package com.mig82.folders.step;

import com.mig82.folders.properties.PropertiesLoader;
import hudson.EnvVars;
import hudson.Extension;
import hudson.model.Job;
import hudson.model.Run;
import hudson.model.TaskListener;
import java.io.IOException;
import java.io.Serializable;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.jenkinsci.plugins.workflow.steps.AbstractSynchronousNonBlockingStepExecution;
import org.jenkinsci.plugins.workflow.steps.BodyInvoker;
import org.jenkinsci.plugins.workflow.steps.EnvironmentExpander;
import org.jenkinsci.plugins.workflow.steps.Step;
import org.jenkinsci.plugins.workflow.steps.StepContext;
import org.jenkinsci.plugins.workflow.steps.StepDescriptor;
import org.jenkinsci.plugins.workflow.steps.StepExecution;
import org.kohsuke.stapler.DataBoundConstructor;

public class FolderPropertiesStep
extends Step
implements Serializable {
    private static final Logger LOGGER = Logger.getLogger(FolderPropertiesStep.class.getName());

    @DataBoundConstructor
    public FolderPropertiesStep() {
    }

    public StepExecution start(StepContext stepContext) throws Exception {
        return new Execution(stepContext, this);
    }

    @Extension
    public static class DescriptorImpl
    extends StepDescriptor {
        public Set<Class<?>> getRequiredContext() {
            return Collections.singleton(TaskListener.class);
        }

        public String getFunctionName() {
            return "withFolderProperties";
        }

        public String getDisplayName() {
            return "A step to retrieve folder properties";
        }

        public boolean takesImplicitBlockArgument() {
            return true;
        }
    }

    private static final class ExpanderImpl
    extends EnvironmentExpander {
        private static final long serialVersionUID = 1L;
        private final EnvVars overrides;

        ExpanderImpl(EnvVars overrides) {
            this.overrides = new EnvVars(overrides);
        }

        public void expand(EnvVars env) throws IOException, InterruptedException {
            env.overrideExpandingAll((Map)this.overrides);
        }
    }

    private static class Execution
    extends AbstractSynchronousNonBlockingStepExecution<Void> {
        private FolderPropertiesStep folderPropertiesStep;

        public Execution(StepContext context, FolderPropertiesStep folderPropertiesStep) {
            super(context);
            this.folderPropertiesStep = folderPropertiesStep;
        }

        protected Void run() throws Exception {
            LOGGER.log(Level.FINER, "Run in 'withFolderProperties' custom pipeline step");
            Job job = ((Run)this.getContext().get(Run.class)).getParent();
            EnvVars envVars = PropertiesLoader.loadFolderProperties(job);
            BodyInvoker bodyInvoker = this.getContext().newBodyInvoker();
            if (!envVars.isEmpty()) {
                LOGGER.log(Level.FINER, "Find the folder properties");
                bodyInvoker.withContext((Object)EnvironmentExpander.merge((EnvironmentExpander)((EnvironmentExpander)this.getContext().get(EnvironmentExpander.class)), (EnvironmentExpander)new ExpanderImpl(envVars)));
            }
            bodyInvoker.start().get();
            return null;
        }
    }
}

