/*
 * Decompiled with CFR 0.152.
 */
package com.midtrans.httpclient;

import com.midtrans.Config;
import com.midtrans.httpclient.error.MidtransError;
import com.midtrans.proxy.ProxyConfig;
import com.midtrans.utils.Utility;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.util.HashMap;
import java.util.Map;
import okhttp3.Authenticator;
import okhttp3.ConnectionPool;
import okhttp3.Credentials;
import okhttp3.Headers;
import okhttp3.Interceptor;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.RequestBody;
import okhttp3.Response;
import okhttp3.logging.HttpLoggingInterceptor;
import org.json.JSONObject;

public class APIHttpClient {
    public Config config;
    public static final String POST = "POST";
    public static final String GET = "GET";
    public static final String PATCH = "PATCH";

    public APIHttpClient(Config config) {
        this.config = config;
    }

    public static <T> T request(String method, String url, Config config, Map<String, ?> requestBody) throws MidtransError {
        OkHttpClient client = APIHttpClient.buildHttpClient(config);
        JSONObject jsonParam = new JSONObject(requestBody);
        RequestBody body = null;
        if (!method.equals(GET)) {
            body = RequestBody.create(null, (String)jsonParam.toString());
        }
        Request request = new Request.Builder().url(url).method(method, body).build();
        try {
            JSONObject jsonObject;
            int statusCode;
            Response response = client.newCall(request).execute();
            assert (response.body() != null);
            String responseBody = response.body().string();
            if (Utility.hasOwnProperty(responseBody, "status_code") && (statusCode = Integer.parseInt((jsonObject = new JSONObject(responseBody)).getString("status_code"))) >= 400 && statusCode != 407) {
                throw new MidtransError("Midtrans API is returning API error. HTTP status code: " + statusCode + " API response: " + responseBody, statusCode, responseBody, response);
            }
            if (response.code() >= 400) {
                throw new MidtransError("Midtrans API is returning API error. HTTP status code: " + response.code() + " API response: " + responseBody, response.code(), responseBody, response);
            }
            return (T)responseBody;
        }
        catch (IOException e) {
            throw new MidtransError("IOException during API request to Midtrans: " + url + " with message: " + e.getMessage() + ". Likely connection failure, please check your internet connection and try again.", 0, null, null, e);
        }
    }

    private static OkHttpClient buildHttpClient(Config config) {
        OkHttpClient httpClient = new OkHttpClient();
        Headers headers = null;
        try {
            headers = APIHttpClient.getHeadersConfig(config);
        }
        catch (MidtransError e) {
            e.printStackTrace();
        }
        Headers finalHeaders = headers;
        Interceptor headersInterceptor = chain -> {
            Request request = chain.request().newBuilder().headers(finalHeaders).build();
            return chain.proceed(request);
        };
        ConnectionPool connectionPool = new ConnectionPool(config.getMaxConnectionPool(), (long)config.getKeepAliveDuration(), config.getHttpClientTimeUnit());
        if (config.getProxyConfig() == null) {
            return httpClient.newBuilder().connectTimeout((long)config.getConnectionTimeout(), config.getHttpClientTimeUnit()).readTimeout((long)config.getReadTimeout(), config.getHttpClientTimeUnit()).writeTimeout((long)config.getWriteTimeout(), config.getHttpClientTimeUnit()).connectionPool(connectionPool).addInterceptor(headersInterceptor).addInterceptor((Interceptor)APIHttpClient.loggingInterceptor(config)).build();
        }
        ProxyConfig proxyConfig = config.getProxyConfig();
        Authenticator proxyAuthenticator = (route, response) -> {
            String credential = Credentials.basic((String)proxyConfig.getUsername(), (String)proxyConfig.getPassword());
            return response.request().newBuilder().header("Proxy-Authorization", credential).build();
        };
        return httpClient.newBuilder().connectTimeout((long)config.getConnectionTimeout(), config.getHttpClientTimeUnit()).readTimeout((long)config.getReadTimeout(), config.getHttpClientTimeUnit()).writeTimeout((long)config.getWriteTimeout(), config.getHttpClientTimeUnit()).connectionPool(connectionPool).proxy(new Proxy(Proxy.Type.HTTP, new InetSocketAddress(proxyConfig.getHost(), proxyConfig.getPort()))).proxyAuthenticator(proxyAuthenticator).addInterceptor(headersInterceptor).addInterceptor((Interceptor)APIHttpClient.loggingInterceptor(config)).build();
    }

    private static Headers getHeadersConfig(Config config) throws MidtransError {
        String serverKey;
        HashMap<String, String> headersMap = new HashMap<String, String>();
        if (config.getCustomHeaders() != null) {
            for (Map.Entry<String, String> headerMap : config.getCustomHeaders().entrySet()) {
                headersMap.put(headerMap.getKey(), headerMap.getValue());
            }
        }
        if ((serverKey = config.getServerKey()) == null) {
            throw new MidtransError("No ServerKey provided. Please set your serverKey key. You can retrieve the ServerKey from the Midtrans Dashboard. See https://docs.midtrans.com/en/midtrans-account/overview?id=retrieving-api-access-keys for the details or contact support at support@midtrans.com if you have any questions.");
        }
        if (serverKey.isEmpty()) {
            throw new MidtransError("The ServerKey is invalid, as it is an empty string. Please double-check your API key. You can check the ServerKey from the Midtrans Dashboard. See https://docs.midtrans.com/en/midtrans-account/overview?id=retrieving-api-access-keys for the details or contact support at support@midtrans.com if you have any questions.");
        }
        if (serverKey.contains(" ")) {
            throw new MidtransError("The ServerKey is contains white-space. Please double-check your API key. You can check the ServerKey from the Midtrans Dashboard. See https://docs.midtrans.com/en/midtrans-account/overview?id=retrieving-api-access-keys for the details or contact support at support@midtrans.com if you have any questions.");
        }
        headersMap.put("Accept", "application/json");
        headersMap.put("Content-Type", "application/json");
        headersMap.put("Authorization", Utility.encodeBase64(serverKey));
        headersMap.put("User-Agent", "Midtrans-Java-Library-" + Utility.getLibraryVersion());
        if (config.getIrisIdempotencyKey() != null) {
            headersMap.put("X-Idempotency-Key", config.getIrisIdempotencyKey());
        }
        if (config.getPaymentIdempotencyKey() != null) {
            headersMap.put("Idempotency-Key", config.getPaymentIdempotencyKey());
        }
        if (config.getPaymentAppendNotification() != null) {
            headersMap.put("X-Append-Notification", config.getPaymentAppendNotification());
        }
        if (config.getPaymentOverrideNotification() != null) {
            headersMap.put("X-Override-Notification", config.getPaymentOverrideNotification());
        }
        return Headers.of(headersMap);
    }

    private static HttpLoggingInterceptor loggingInterceptor(Config config) {
        HttpLoggingInterceptor logging = new HttpLoggingInterceptor();
        if (config.isEnabledLog()) {
            return logging.setLevel(HttpLoggingInterceptor.Level.BODY);
        }
        return logging.setLevel(HttpLoggingInterceptor.Level.NONE);
    }
}

