/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.microsoft.windowsazure.services.core.ISO8601DateConverter;
import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.CommaStringBuilder;
import com.microsoft.windowsazure.services.core.utils.DateFactory;
import com.microsoft.windowsazure.services.core.utils.ServiceExceptionFactory;
import com.microsoft.windowsazure.services.core.utils.pipeline.ClientFilterAdapter;
import com.microsoft.windowsazure.services.core.utils.pipeline.HttpURLConnectionClient;
import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.services.table.TableContract;
import com.microsoft.windowsazure.services.table.implementation.AtomReaderWriter;
import com.microsoft.windowsazure.services.table.implementation.HttpReaderWriter;
import com.microsoft.windowsazure.services.table.implementation.InputStreamDataSource;
import com.microsoft.windowsazure.services.table.implementation.MimeReaderWriter;
import com.microsoft.windowsazure.services.table.implementation.SharedKeyFilter;
import com.microsoft.windowsazure.services.table.models.BatchOperations;
import com.microsoft.windowsazure.services.table.models.BatchResult;
import com.microsoft.windowsazure.services.table.models.BinaryFilter;
import com.microsoft.windowsazure.services.table.models.ConstantFilter;
import com.microsoft.windowsazure.services.table.models.DeleteEntityOptions;
import com.microsoft.windowsazure.services.table.models.Entity;
import com.microsoft.windowsazure.services.table.models.Filter;
import com.microsoft.windowsazure.services.table.models.GetEntityResult;
import com.microsoft.windowsazure.services.table.models.GetServicePropertiesResult;
import com.microsoft.windowsazure.services.table.models.GetTableResult;
import com.microsoft.windowsazure.services.table.models.InsertEntityResult;
import com.microsoft.windowsazure.services.table.models.PropertyNameFilter;
import com.microsoft.windowsazure.services.table.models.QueryEntitiesOptions;
import com.microsoft.windowsazure.services.table.models.QueryEntitiesResult;
import com.microsoft.windowsazure.services.table.models.QueryStringFilter;
import com.microsoft.windowsazure.services.table.models.QueryTablesOptions;
import com.microsoft.windowsazure.services.table.models.QueryTablesResult;
import com.microsoft.windowsazure.services.table.models.ServiceProperties;
import com.microsoft.windowsazure.services.table.models.TableServiceOptions;
import com.microsoft.windowsazure.services.table.models.UnaryFilter;
import com.microsoft.windowsazure.services.table.models.UpdateEntityResult;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.UniformInterfaceException;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.core.header.InBoundHeaders;
import com.sun.jersey.core.util.ReaderWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.Enumeration;
import java.util.Formatter;
import java.util.List;
import java.util.UUID;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.inject.Named;
import javax.mail.Header;
import javax.mail.internet.InternetHeaders;
import javax.mail.internet.MimeMultipart;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class TableRestProxy
implements TableContract {
    private static final String API_VERSION = "2011-08-18";
    private final HttpURLConnectionClient channel;
    private final String url;
    private final RFC1123DateConverter dateMapper;
    private final ISO8601DateConverter iso8601DateConverter;
    private final DateFactory dateFactory;
    private final ServiceFilter[] filters;
    private final SharedKeyFilter filter;
    private final AtomReaderWriter atomReaderWriter;
    private final MimeReaderWriter mimeReaderWriter;
    private final HttpReaderWriter httpReaderWriter;

    @Inject
    public TableRestProxy(HttpURLConnectionClient channel, @Named(value="table.uri") String url, SharedKeyFilter filter, UserAgentFilter userAgentFilter, DateFactory dateFactory, ISO8601DateConverter iso8601DateConverter, AtomReaderWriter atomReaderWriter, MimeReaderWriter mimeReaderWriter, HttpReaderWriter httpReaderWriter) {
        this.channel = channel;
        this.url = url;
        this.filter = filter;
        this.dateMapper = new RFC1123DateConverter();
        this.iso8601DateConverter = iso8601DateConverter;
        this.filters = new ServiceFilter[0];
        this.dateFactory = dateFactory;
        this.atomReaderWriter = atomReaderWriter;
        this.mimeReaderWriter = mimeReaderWriter;
        this.httpReaderWriter = httpReaderWriter;
        channel.addFilter(filter);
        channel.addFilter(userAgentFilter);
    }

    public TableRestProxy(HttpURLConnectionClient channel, ServiceFilter[] filters, String url, SharedKeyFilter filter, DateFactory dateFactory, AtomReaderWriter atomReaderWriter, MimeReaderWriter mimeReaderWriter, HttpReaderWriter httpReaderWriter, RFC1123DateConverter dateMapper, ISO8601DateConverter iso8601DateConverter) {
        this.channel = channel;
        this.filters = filters;
        this.url = url;
        this.filter = filter;
        this.dateFactory = dateFactory;
        this.atomReaderWriter = atomReaderWriter;
        this.mimeReaderWriter = mimeReaderWriter;
        this.httpReaderWriter = httpReaderWriter;
        this.dateMapper = dateMapper;
        this.iso8601DateConverter = iso8601DateConverter;
    }

    @Override
    public TableContract withFilter(ServiceFilter filter) {
        ServiceFilter[] newFilters = Arrays.copyOf(this.filters, this.filters.length + 1);
        newFilters[this.filters.length] = filter;
        return new TableRestProxy(this.channel, newFilters, this.url, this.filter, this.dateFactory, this.atomReaderWriter, this.mimeReaderWriter, this.httpReaderWriter, this.dateMapper, this.iso8601DateConverter);
    }

    private void ThrowIfError(ClientResponse r) {
        PipelineHelpers.ThrowIfError(r);
    }

    private String encodeODataURIValue(String value) {
        return value;
    }

    private List<String> encodeODataURIValues(List<String> values) {
        ArrayList<String> list = new ArrayList<String>();
        for (String value : values) {
            list.add(this.encodeODataURIValue(value));
        }
        return list;
    }

    private String getEntityPath(String table, String partitionKey, String rowKey) {
        return table + "(" + "PartitionKey='" + this.safeEncode(partitionKey) + "',RowKey='" + this.safeEncode(rowKey) + "')";
    }

    private String safeEncode(String input) {
        String fixSingleQuotes = input.replace("'", "''");
        try {
            return URLEncoder.encode(fixSingleQuotes, "UTF-8").replace("+", "%20");
        }
        catch (UnsupportedEncodingException e) {
            return fixSingleQuotes;
        }
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, Object value) {
        return PipelineHelpers.addOptionalQueryParam(webResource, key, value);
    }

    private WebResource addOptionalQueryEntitiesOptions(WebResource webResource, QueryEntitiesOptions queryEntitiesOptions) {
        if (queryEntitiesOptions == null) {
            return webResource;
        }
        if (queryEntitiesOptions.getSelectFields() != null && queryEntitiesOptions.getSelectFields().size() > 0) {
            webResource = this.addOptionalQueryParam(webResource, "$select", CommaStringBuilder.join(this.encodeODataURIValues(queryEntitiesOptions.getSelectFields())));
        }
        if (queryEntitiesOptions.getTop() != null) {
            webResource = this.addOptionalQueryParam(webResource, "$top", this.encodeODataURIValue(queryEntitiesOptions.getTop().toString()));
        }
        if (queryEntitiesOptions.getFilter() != null) {
            webResource = this.addOptionalQueryParam(webResource, "$filter", this.buildFilterExpression(queryEntitiesOptions.getFilter()));
        }
        if (queryEntitiesOptions.getOrderByFields() != null) {
            webResource = this.addOptionalQueryParam(webResource, "$orderby", CommaStringBuilder.join(this.encodeODataURIValues(queryEntitiesOptions.getOrderByFields())));
        }
        return webResource;
    }

    private String buildFilterExpression(Filter filter) {
        StringBuilder sb = new StringBuilder();
        this.buildFilterExpression(filter, sb);
        return sb.toString();
    }

    private void buildFilterExpression(Filter filter, StringBuilder sb) {
        if (filter == null) {
            return;
        }
        if (filter instanceof PropertyNameFilter) {
            sb.append(((PropertyNameFilter)filter).getPropertyName());
        } else if (filter instanceof ConstantFilter) {
            Object value = ((ConstantFilter)filter).getValue();
            if (value == null) {
                sb.append("null");
            } else if (value.getClass() == Long.class) {
                sb.append(value);
                sb.append("L");
            } else if (value.getClass() == Date.class) {
                ISO8601DateConverter dateConverter = new ISO8601DateConverter();
                sb.append("datetime'");
                sb.append(dateConverter.format((Date)value));
                sb.append("'");
            } else if (value.getClass() == UUID.class) {
                sb.append("(guid'");
                sb.append(value);
                sb.append("')");
            } else if (value.getClass() == String.class) {
                sb.append("'");
                sb.append(((String)value).replace("'", "''"));
                sb.append("'");
            } else if (value.getClass() == byte[].class) {
                sb.append("X'");
                byte[] byteArray = (byte[])value;
                Formatter formatter = new Formatter(sb);
                for (byte b : byteArray) {
                    formatter.format("%02x", b);
                }
                formatter.flush();
                formatter.close();
                sb.append("'");
            } else if (value.getClass() == Byte[].class) {
                sb.append("X'");
                Byte[] byteArray = (Byte[])value;
                Formatter formatter = new Formatter(sb);
                for (Byte b : byteArray) {
                    formatter.format("%02x", b);
                }
                formatter.flush();
                formatter.close();
                sb.append("'");
            } else {
                sb.append(value);
            }
        } else if (filter instanceof UnaryFilter) {
            sb.append(((UnaryFilter)filter).getOperator());
            sb.append("(");
            this.buildFilterExpression(((UnaryFilter)filter).getOperand(), sb);
            sb.append(")");
        } else if (filter instanceof BinaryFilter) {
            sb.append("(");
            this.buildFilterExpression(((BinaryFilter)filter).getLeft(), sb);
            sb.append(" ");
            sb.append(((BinaryFilter)filter).getOperator());
            sb.append(" ");
            this.buildFilterExpression(((BinaryFilter)filter).getRight(), sb);
            sb.append(")");
        } else if (filter instanceof QueryStringFilter) {
            sb.append(((QueryStringFilter)filter).getQueryString());
        }
    }

    private WebResource.Builder addOptionalHeader(WebResource.Builder builder, String name, Object value) {
        return PipelineHelpers.addOptionalHeader(builder, name, value);
    }

    private WebResource.Builder addTableRequestHeaders(WebResource.Builder builder) {
        builder = this.addOptionalHeader(builder, "x-ms-version", API_VERSION);
        builder = this.addOptionalHeader(builder, "DataServiceVersion", "1.0;NetFx");
        builder = this.addOptionalHeader(builder, "MaxDataServiceVersion", "2.0;NetFx");
        builder = this.addOptionalHeader(builder, "Accept", "application/atom+xml,application/xml");
        builder = this.addOptionalHeader(builder, "Accept-Charset", "UTF-8");
        return builder;
    }

    private WebResource.Builder addIfMatchHeader(WebResource.Builder builder, String eTag) {
        builder = this.addOptionalHeader(builder, "If-Match", eTag == null ? "*" : eTag);
        return builder;
    }

    private WebResource getResource(TableServiceOptions options) {
        WebResource webResource = this.channel.resource(this.url).path("/");
        for (ServiceFilter filter : this.filters) {
            webResource.addFilter((ClientFilter)new ClientFilterAdapter(filter));
        }
        return webResource;
    }

    @Override
    public GetServicePropertiesResult getServiceProperties() throws ServiceException {
        return this.getServiceProperties(new TableServiceOptions());
    }

    @Override
    public GetServicePropertiesResult getServiceProperties(TableServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        GetServicePropertiesResult result = new GetServicePropertiesResult();
        result.setValue((ServiceProperties)builder.get(ServiceProperties.class));
        return result;
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties) throws ServiceException {
        this.setServiceProperties(serviceProperties, new TableServiceOptions());
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties, TableServiceOptions options) throws ServiceException {
        if (serviceProperties == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.put((Object)serviceProperties);
    }

    @Override
    public GetTableResult getTable(String table) throws ServiceException {
        return this.getTable(table, new TableServiceOptions());
    }

    @Override
    public GetTableResult getTable(String table, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path("Tables('" + table + "')");
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        GetTableResult result = new GetTableResult();
        result.setTableEntry(this.atomReaderWriter.parseTableEntry(response.getEntityInputStream()));
        return result;
    }

    @Override
    public QueryTablesResult queryTables() throws ServiceException {
        return this.queryTables(new QueryTablesOptions());
    }

    @Override
    public QueryTablesResult queryTables(QueryTablesOptions options) throws ServiceException {
        Filter queryFilter = options.getFilter();
        String nextTableName = options.getNextTableName();
        String prefix = options.getPrefix();
        if (prefix != null) {
            BinaryFilter prefixFilter = Filter.and(Filter.ge(Filter.propertyName("TableName"), Filter.constant(prefix)), Filter.le(Filter.propertyName("TableName"), Filter.constant(prefix + "{")));
            queryFilter = queryFilter == null ? prefixFilter : Filter.and(queryFilter, prefixFilter);
        }
        WebResource webResource = this.getResource(options).path("Tables");
        webResource = this.addOptionalQueryParam(webResource, "$filter", this.buildFilterExpression(queryFilter));
        webResource = this.addOptionalQueryParam(webResource, "NextTableName", nextTableName);
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        QueryTablesResult result = new QueryTablesResult();
        result.setNextTableName((String)response.getHeaders().getFirst((Object)"x-ms-continuation-NextTableName"));
        result.setTables(this.atomReaderWriter.parseTableEntries(response.getEntityInputStream()));
        return result;
    }

    @Override
    public void createTable(String table) throws ServiceException {
        this.createTable(table, new TableServiceOptions());
    }

    @Override
    public void createTable(String table, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path("Tables");
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        builder.entity((Object)this.atomReaderWriter.generateTableEntry(table), "application/atom+xml");
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class);
        this.ThrowIfError(response);
    }

    @Override
    public void deleteTable(String table) throws ServiceException {
        this.deleteTable(table, new TableServiceOptions());
    }

    @Override
    public void deleteTable(String table, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path("Tables('" + table + "')");
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        builder = this.addOptionalHeader(builder, "Content-Type", "application/atom+xml");
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        this.ThrowIfError(response);
    }

    @Override
    public InsertEntityResult insertEntity(String table, Entity entity) throws ServiceException {
        return this.insertEntity(table, entity, new TableServiceOptions());
    }

    @Override
    public InsertEntityResult insertEntity(String table, Entity entity, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(table);
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        builder = (WebResource.Builder)builder.entity((Object)this.atomReaderWriter.generateEntityEntry(entity), "application/atom+xml");
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class);
        this.ThrowIfError(response);
        InsertEntityResult result = new InsertEntityResult();
        result.setEntity(this.atomReaderWriter.parseEntityEntry(response.getEntityInputStream()));
        return result;
    }

    @Override
    public UpdateEntityResult updateEntity(String table, Entity entity) throws ServiceException {
        return this.updateEntity(table, entity, new TableServiceOptions());
    }

    @Override
    public UpdateEntityResult updateEntity(String table, Entity entity, TableServiceOptions options) throws ServiceException {
        return this.putOrMergeEntityCore(table, entity, "PUT", true, options);
    }

    @Override
    public UpdateEntityResult mergeEntity(String table, Entity entity) throws ServiceException {
        return this.mergeEntity(table, entity, new TableServiceOptions());
    }

    @Override
    public UpdateEntityResult mergeEntity(String table, Entity entity, TableServiceOptions options) throws ServiceException {
        return this.putOrMergeEntityCore(table, entity, "MERGE", true, options);
    }

    @Override
    public UpdateEntityResult insertOrReplaceEntity(String table, Entity entity) throws ServiceException {
        return this.insertOrReplaceEntity(table, entity, new TableServiceOptions());
    }

    @Override
    public UpdateEntityResult insertOrReplaceEntity(String table, Entity entity, TableServiceOptions options) throws ServiceException {
        return this.putOrMergeEntityCore(table, entity, "PUT", false, options);
    }

    @Override
    public UpdateEntityResult insertOrMergeEntity(String table, Entity entity) throws ServiceException {
        return this.insertOrMergeEntity(table, entity, new TableServiceOptions());
    }

    @Override
    public UpdateEntityResult insertOrMergeEntity(String table, Entity entity, TableServiceOptions options) throws ServiceException {
        return this.putOrMergeEntityCore(table, entity, "MERGE", false, options);
    }

    private UpdateEntityResult putOrMergeEntityCore(String table, Entity entity, String verb, boolean includeEtag, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(this.getEntityPath(table, entity.getPartitionKey(), entity.getRowKey()));
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        if (includeEtag) {
            builder = this.addIfMatchHeader(builder, entity.getEtag());
        }
        if (verb == "MERGE") {
            builder = (WebResource.Builder)builder.header("X-HTTP-Method", (Object)"MERGE");
            verb = "POST";
        }
        builder = (WebResource.Builder)builder.entity((Object)this.atomReaderWriter.generateEntityEntry(entity), "application/atom+xml");
        ClientResponse response = (ClientResponse)builder.method(verb, ClientResponse.class);
        this.ThrowIfError(response);
        UpdateEntityResult result = new UpdateEntityResult();
        result.setEtag((String)response.getHeaders().getFirst((Object)"ETag"));
        return result;
    }

    @Override
    public void deleteEntity(String table, String partitionKey, String rowKey) throws ServiceException {
        this.deleteEntity(table, partitionKey, rowKey, new DeleteEntityOptions());
    }

    @Override
    public void deleteEntity(String table, String partitionKey, String rowKey, DeleteEntityOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(this.getEntityPath(table, partitionKey, rowKey));
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        builder = this.addIfMatchHeader(builder, options.getEtag());
        ClientResponse response = (ClientResponse)builder.delete(ClientResponse.class);
        this.ThrowIfError(response);
    }

    @Override
    public GetEntityResult getEntity(String table, String partitionKey, String rowKey) throws ServiceException {
        return this.getEntity(table, partitionKey, rowKey, new TableServiceOptions());
    }

    @Override
    public GetEntityResult getEntity(String table, String partitionKey, String rowKey, TableServiceOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(this.getEntityPath(table, partitionKey, rowKey));
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        GetEntityResult result = new GetEntityResult();
        result.setEntity(this.atomReaderWriter.parseEntityEntry(response.getEntityInputStream()));
        return result;
    }

    @Override
    public QueryEntitiesResult queryEntities(String table) throws ServiceException {
        return this.queryEntities(table, new QueryEntitiesOptions());
    }

    @Override
    public QueryEntitiesResult queryEntities(String table, QueryEntitiesOptions options) throws ServiceException {
        if (table == null) {
            throw new NullPointerException();
        }
        if (options == null) {
            options = new QueryEntitiesOptions();
        }
        WebResource webResource = this.getResource(options).path(table);
        webResource = this.addOptionalQueryEntitiesOptions(webResource, options);
        webResource = this.addOptionalQueryParam(webResource, "NextPartitionKey", this.encodeODataURIValue(options.getNextPartitionKey()));
        webResource = this.addOptionalQueryParam(webResource, "NextRowKey", this.encodeODataURIValue(options.getNextRowKey()));
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        QueryEntitiesResult result = new QueryEntitiesResult();
        result.setNextPartitionKey((String)response.getHeaders().getFirst((Object)"x-ms-continuation-NextPartitionKey"));
        result.setNextRowKey((String)response.getHeaders().getFirst((Object)"x-ms-continuation-NextRowKey"));
        result.setEntities(this.atomReaderWriter.parseEntityEntries(response.getEntityInputStream()));
        return result;
    }

    @Override
    public BatchResult batch(BatchOperations operations) throws ServiceException {
        return this.batch(operations, new TableServiceOptions());
    }

    @Override
    public BatchResult batch(BatchOperations operations, TableServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("$batch");
        WebResource.Builder builder = webResource.getRequestBuilder();
        builder = this.addTableRequestHeaders(builder);
        MimeMultipart entity = this.createBatchRequestBody(operations);
        builder = (WebResource.Builder)builder.type(entity.getContentType());
        ClientResponse response = (ClientResponse)builder.post(ClientResponse.class, (Object)entity);
        this.ThrowIfError(response);
        BatchResult result = new BatchResult();
        try {
            result.setEntries(this.parseBatchResponse(response, operations));
        }
        catch (IOException e) {
            throw new ServiceException(e);
        }
        return result;
    }

    private MimeMultipart createBatchRequestBody(BatchOperations operations) {
        ArrayList<DataSource> bodyPartContents = new ArrayList<DataSource>();
        int contentId = 1;
        for (BatchOperations.Operation operation : operations.getOperations()) {
            BatchOperations.Operation op;
            DataSource bodyPartContent = null;
            if (operation instanceof BatchOperations.InsertEntityOperation) {
                op = (BatchOperations.InsertEntityOperation)operation;
                bodyPartContent = this.createBatchInsertOrUpdateEntityPart(((BatchOperations.InsertEntityOperation)op).getTable(), ((BatchOperations.InsertEntityOperation)op).getEntity(), "POST", false, contentId);
                ++contentId;
            } else if (operation instanceof BatchOperations.UpdateEntityOperation) {
                op = (BatchOperations.UpdateEntityOperation)operation;
                bodyPartContent = this.createBatchInsertOrUpdateEntityPart(((BatchOperations.UpdateEntityOperation)op).getTable(), ((BatchOperations.UpdateEntityOperation)op).getEntity(), "PUT", true, contentId);
                ++contentId;
            } else if (operation instanceof BatchOperations.MergeEntityOperation) {
                op = (BatchOperations.MergeEntityOperation)operation;
                bodyPartContent = this.createBatchInsertOrUpdateEntityPart(((BatchOperations.MergeEntityOperation)op).getTable(), ((BatchOperations.MergeEntityOperation)op).getEntity(), "MERGE", true, contentId);
                ++contentId;
            } else if (operation instanceof BatchOperations.InsertOrReplaceEntityOperation) {
                op = (BatchOperations.InsertOrReplaceEntityOperation)operation;
                bodyPartContent = this.createBatchInsertOrUpdateEntityPart(((BatchOperations.InsertOrReplaceEntityOperation)op).getTable(), ((BatchOperations.InsertOrReplaceEntityOperation)op).getEntity(), "PUT", false, contentId);
                ++contentId;
            } else if (operation instanceof BatchOperations.InsertOrMergeEntityOperation) {
                op = (BatchOperations.InsertOrMergeEntityOperation)operation;
                bodyPartContent = this.createBatchInsertOrUpdateEntityPart(((BatchOperations.InsertOrMergeEntityOperation)op).getTable(), ((BatchOperations.InsertOrMergeEntityOperation)op).getEntity(), "MERGE", false, contentId);
                ++contentId;
            } else if (operation instanceof BatchOperations.DeleteEntityOperation) {
                op = (BatchOperations.DeleteEntityOperation)operation;
                bodyPartContent = this.createBatchDeleteEntityPart(((BatchOperations.DeleteEntityOperation)op).getTable(), ((BatchOperations.DeleteEntityOperation)op).getPartitionKey(), ((BatchOperations.DeleteEntityOperation)op).getRowKey(), ((BatchOperations.DeleteEntityOperation)op).getEtag(), contentId);
                ++contentId;
            }
            if (bodyPartContent == null) continue;
            bodyPartContents.add(bodyPartContent);
        }
        return this.mimeReaderWriter.getMimeMultipart(bodyPartContents);
    }

    private DataSource createBatchInsertOrUpdateEntityPart(String table, Entity entity, String verb, boolean includeEtag, int contentId) {
        URI path = "POST".equals(verb) ? this.channel.resource(this.url).path(table).getURI() : this.channel.resource(this.url).path(this.getEntityPath(table, entity.getPartitionKey(), entity.getRowKey())).getURI();
        InputStream stream = this.atomReaderWriter.generateEntityEntry(entity);
        byte[] bytes = this.inputStreamToByteArray(stream);
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-ID", Integer.toString(contentId));
        headers.addHeader("Content-Type", "application/atom+xml;type=entry");
        headers.addHeader("Content-Length", Integer.toString(bytes.length));
        if (includeEtag) {
            headers.addHeader("If-Match", entity.getEtag());
        }
        ByteArrayOutputStream httpRequest = new ByteArrayOutputStream();
        this.httpReaderWriter.appendMethod(httpRequest, verb, path);
        this.httpReaderWriter.appendHeaders(httpRequest, headers);
        this.httpReaderWriter.appendEntity(httpRequest, new ByteArrayInputStream(bytes));
        InputStreamDataSource bodyPartContent = new InputStreamDataSource(new ByteArrayInputStream(httpRequest.toByteArray()), "application/http");
        return bodyPartContent;
    }

    private DataSource createBatchDeleteEntityPart(String table, String partitionKey, String rowKey, String etag, int contentId) {
        URI path = this.channel.resource(this.url).path(this.getEntityPath(table, partitionKey, rowKey)).getURI();
        InternetHeaders headers = new InternetHeaders();
        headers.addHeader("Content-ID", Integer.toString(contentId));
        headers.addHeader("If-Match", etag == null ? "*" : etag);
        ByteArrayOutputStream httpRequest = new ByteArrayOutputStream();
        this.httpReaderWriter.appendMethod(httpRequest, "DELETE", path);
        this.httpReaderWriter.appendHeaders(httpRequest, headers);
        this.httpReaderWriter.appendEntity(httpRequest, new ByteArrayInputStream(new byte[0]));
        InputStreamDataSource bodyPartContent = new InputStreamDataSource(new ByteArrayInputStream(httpRequest.toByteArray()), "application/http");
        return bodyPartContent;
    }

    private List<BatchResult.Entry> parseBatchResponse(ClientResponse response, BatchOperations operations) throws IOException {
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        InputStream inputStream = response.getEntityInputStream();
        ReaderWriter.writeTo((InputStream)inputStream, (OutputStream)byteArrayOutputStream);
        response.setEntityInputStream((InputStream)new ByteArrayInputStream(byteArrayOutputStream.toByteArray()));
        List<DataSource> parts = this.mimeReaderWriter.parseParts(response.getEntityInputStream(), (String)response.getHeaders().getFirst((Object)"Content-Type"));
        if (parts.size() == 0 || parts.size() > operations.getOperations().size()) {
            throw new UniformInterfaceException(String.format("Batch response from server does not contain the correct amount of parts (expecting %d, received %d instead)", parts.size(), operations.getOperations().size()), response);
        }
        BatchResult.Entry[] entries = new BatchResult.Entry[operations.getOperations().size()];
        for (int i = 0; i < parts.size(); ++i) {
            BatchResult.Entry opResult;
            DataSource ds = parts.get(i);
            BatchOperations.Operation operation = operations.getOperations().get(i);
            HttpReaderWriter.StatusLine status = this.httpReaderWriter.parseStatusLine(ds);
            InternetHeaders headers = this.httpReaderWriter.parseHeaders(ds);
            InputStream content = this.httpReaderWriter.parseEntity(ds);
            ByteArrayOutputStream contentByteArrayOutputStream = new ByteArrayOutputStream();
            ReaderWriter.writeTo((InputStream)content, (OutputStream)contentByteArrayOutputStream);
            content = new ByteArrayInputStream(contentByteArrayOutputStream.toByteArray());
            if (status.getStatus() >= 400) {
                InBoundHeaders inBoundHeaders = new InBoundHeaders();
                Enumeration e = headers.getAllHeaders();
                while (e.hasMoreElements()) {
                    Header header = (Header)e.nextElement();
                    inBoundHeaders.putSingle(header.getName(), (Object)header.getValue());
                }
                ClientResponse dummyResponse = new ClientResponse(status.getStatus(), inBoundHeaders, content, null);
                UniformInterfaceException exception = new UniformInterfaceException(dummyResponse);
                ServiceException serviceException = new ServiceException(exception);
                serviceException = ServiceExceptionFactory.process("table", serviceException);
                BatchResult.Error error = new BatchResult.Error().setError(serviceException);
                try {
                    XMLInputFactory xmlStreamFactory = XMLInputFactory.newFactory();
                    content.reset();
                    XMLStreamReader xmlStreamReader = xmlStreamFactory.createXMLStreamReader(content);
                    while (xmlStreamReader.hasNext()) {
                        xmlStreamReader.next();
                        if (!xmlStreamReader.isStartElement() || !"message".equals(xmlStreamReader.getLocalName())) continue;
                        xmlStreamReader.next();
                        String message = xmlStreamReader.getText();
                        int colonIndex = message.indexOf(58);
                        String errorOpId = message.substring(0, colonIndex);
                        int opId = Integer.parseInt(errorOpId);
                        entries[opId] = error;
                        break;
                    }
                    xmlStreamReader.close();
                    continue;
                }
                catch (XMLStreamException e1) {
                    throw new UniformInterfaceException("Batch response from server does not contain XML in the expected format", response);
                }
            }
            if (operation instanceof BatchOperations.InsertEntityOperation) {
                opResult = new BatchResult.InsertEntity().setEntity(this.atomReaderWriter.parseEntityEntry(content));
                entries[i] = opResult;
                continue;
            }
            if (operation instanceof BatchOperations.UpdateEntityOperation || operation instanceof BatchOperations.MergeEntityOperation || operation instanceof BatchOperations.InsertOrReplaceEntityOperation || operation instanceof BatchOperations.InsertOrMergeEntityOperation) {
                opResult = new BatchResult.UpdateEntity().setEtag(headers.getHeader("ETag", null));
                entries[i] = opResult;
                continue;
            }
            if (!(operation instanceof BatchOperations.DeleteEntityOperation)) continue;
            opResult = new BatchResult.DeleteEntity();
            entries[i] = opResult;
        }
        ArrayList<BatchResult.Entry> result = new ArrayList<BatchResult.Entry>();
        for (int i = 0; i < entries.length; ++i) {
            result.add(entries[i]);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] inputStreamToByteArray(InputStream inputStream) {
        try {
            ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
            byte[] buffer = new byte[1024];
            try {
                int n;
                while ((n = inputStream.read(buffer)) != -1) {
                    outputStream.write(buffer, 0, n);
                }
            }
            finally {
                inputStream.close();
            }
            return outputStream.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

