/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.microsoft.windowsazure.services.blob.implementation.SharedKeyUtils;
import com.sun.jersey.api.client.ClientRequest;
import java.util.List;
import javax.inject.Named;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class SharedKeyFilter
extends com.microsoft.windowsazure.services.blob.implementation.SharedKeyFilter {
    private static Log log = LogFactory.getLog(SharedKeyFilter.class);

    public SharedKeyFilter(@Named(value="table.accountName") String accountName, @Named(value="table.accountKey") String accountKey) {
        super(accountName, accountKey);
    }

    @Override
    public void sign(ClientRequest cr) {
        this.addOptionalDateHeader(cr);
        String stringToSign = cr.getMethod() + "\n" + this.getHeader(cr, "Content-MD5") + "\n" + this.getHeader(cr, "Content-Type") + "\n" + this.getHeader(cr, "Date") + "\n";
        stringToSign = stringToSign + this.getCanonicalizedResource(cr);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("String to sign: \"%s\"", stringToSign));
        }
        String signature = this.getSigner().sign(stringToSign);
        cr.getHeaders().putSingle((Object)"Authorization", (Object)("SharedKey " + this.getAccountName() + ":" + signature));
    }

    private String getCanonicalizedResource(ClientRequest cr) {
        String result = "/" + this.getAccountName();
        result = result + cr.getURI().getRawPath();
        List<SharedKeyUtils.QueryParam> queryParams = SharedKeyUtils.getQueryParams(cr.getURI().getQuery());
        for (SharedKeyUtils.QueryParam p : queryParams) {
            if (!"comp".equals(p.getName())) continue;
            result = result + "?" + p.getName() + "=" + p.getValues().get(0);
        }
        return result;
    }
}

