/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.sun.mail.util.LineInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.util.Enumeration;
import javax.activation.DataSource;
import javax.inject.Inject;
import javax.mail.Header;
import javax.mail.MessagingException;
import javax.mail.internet.InternetHeaders;

public class HttpReaderWriter {
    @Inject
    public HttpReaderWriter() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public StatusLine parseStatusLine(DataSource ds) {
        StatusLine statusLine;
        LineInputStream stream = new LineInputStream(ds.getInputStream());
        try {
            String line = stream.readLine();
            StringReader lineReader = new StringReader(line);
            this.expect(lineReader, "HTTP/1.1");
            this.expect(lineReader, " ");
            String statusString = this.extractInput(lineReader, 32);
            String reason = this.extractInput(lineReader, -1);
            statusLine = new StatusLine().setStatus(Integer.parseInt(statusString)).setReason(reason);
        }
        catch (Throwable throwable) {
            try {
                stream.close();
                throw throwable;
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        stream.close();
        return statusLine;
    }

    public InternetHeaders parseHeaders(DataSource ds) {
        try {
            return new InternetHeaders(ds.getInputStream());
        }
        catch (MessagingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public InputStream parseEntity(DataSource ds) {
        try {
            return ds.getInputStream();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendMethod(OutputStream stream, String verb, URI uri) {
        try {
            String method = String.format("%s %s %s\r\n", verb, uri, "HTTP/1.1");
            stream.write(method.getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendHeaders(OutputStream stream, InternetHeaders headers) {
        try {
            Enumeration e = headers.getAllHeaders();
            while (e.hasMoreElements()) {
                Header header = (Header)e.nextElement();
                String headerLine = String.format("%s: %s\r\n", header.getName(), header.getValue());
                stream.write(headerLine.getBytes("UTF-8"));
            }
            stream.write("\r\n".getBytes("UTF-8"));
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void appendEntity(OutputStream stream, InputStream entity) {
        try {
            int n;
            byte[] buffer = new byte[1024];
            while ((n = entity.read(buffer)) != -1) {
                stream.write(buffer, 0, n);
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void expect(Reader reader, String string) {
        try {
            for (int i = 0; i < string.length(); ++i) {
                int ch = reader.read();
                if (ch >= 0) continue;
                throw new RuntimeException(String.format("Expected '%s', found '%s' instead", string, string.substring(0, i) + ch));
            }
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private String extractInput(Reader reader, int delimiter) {
        try {
            int ch;
            StringBuilder sb = new StringBuilder();
            while ((ch = reader.read()) != -1 && ch != delimiter) {
                sb.append((char)ch);
            }
            return sb.toString();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public class StatusLine {
        private int status;
        private String reason;

        public int getStatus() {
            return this.status;
        }

        public StatusLine setStatus(int status) {
            this.status = status;
            return this;
        }

        public String getReason() {
            return this.reason;
        }

        public StatusLine setReason(String reason) {
            this.reason = reason;
            return this;
        }
    }
}

