/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.implementation;

import com.microsoft.windowsazure.services.core.ISO8601DateConverter;
import com.microsoft.windowsazure.services.core.utils.DateFactory;
import com.microsoft.windowsazure.services.table.EdmValueConverter;
import com.microsoft.windowsazure.services.table.implementation.XMLStreamFactory;
import com.microsoft.windowsazure.services.table.models.Entity;
import com.microsoft.windowsazure.services.table.models.Property;
import com.microsoft.windowsazure.services.table.models.TableEntry;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.stream.XMLStreamWriter;

public class AtomReaderWriter {
    private final XMLStreamFactory xmlStreamFactory;
    private final DateFactory dateFactory;
    private final ISO8601DateConverter iso8601DateConverter;
    private final EdmValueConverter edmValueConverter;

    @Inject
    public AtomReaderWriter(XMLStreamFactory xmlStreamFactory, DateFactory dateFactory, ISO8601DateConverter iso8601DateConverter, EdmValueConverter edmValueConverter) {
        this.xmlStreamFactory = xmlStreamFactory;
        this.dateFactory = dateFactory;
        this.iso8601DateConverter = iso8601DateConverter;
        this.edmValueConverter = edmValueConverter;
    }

    public InputStream generateTableEntry(String table) {
        final String tableTemp = table;
        return this.generateEntry(new PropertiesWriter(){

            @Override
            public void write(XMLStreamWriter writer) throws XMLStreamException {
                writer.writeStartElement("d:TableName");
                writer.writeCharacters(tableTemp);
                writer.writeEndElement();
            }
        });
    }

    public InputStream generateEntityEntry(Entity entity) {
        final Entity entityTemp = entity;
        return this.generateEntry(new PropertiesWriter(){

            @Override
            public void write(XMLStreamWriter writer) throws XMLStreamException {
                for (Map.Entry<String, Property> entry : entityTemp.getProperties().entrySet()) {
                    writer.writeStartElement("d:" + entry.getKey());
                    String edmType = entry.getValue().getEdmType();
                    if (edmType != null) {
                        writer.writeAttribute("m:type", edmType);
                    }
                    String value = AtomReaderWriter.this.edmValueConverter.serialize(edmType, entry.getValue().getValue());
                    if (edmType != null && edmType == "Edm.String") {
                        value = AtomReaderWriter.this.encodeNumericCharacterReference(value);
                    }
                    if (value != null) {
                        writer.writeCharacters(value);
                    } else {
                        writer.writeAttribute("m:null", "true");
                    }
                    writer.writeEndElement();
                }
            }
        });
    }

    public List<TableEntry> parseTableEntries(InputStream stream) {
        try {
            XMLStreamReader xmlr = this.xmlStreamFactory.getReader(stream);
            this.expect(xmlr, 7);
            this.expect(xmlr, 1, "feed");
            ArrayList<TableEntry> result = new ArrayList<TableEntry>();
            while (!this.isEndElement(xmlr, "feed")) {
                if (this.isStartElement(xmlr, "entry")) {
                    result.add(this.parseTableEntry(xmlr));
                    continue;
                }
                this.nextSignificant(xmlr);
            }
            this.expect(xmlr, 2, "feed");
            this.expect(xmlr, 8);
            return result;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public TableEntry parseTableEntry(InputStream stream) {
        try {
            XMLStreamReader xmlr = this.xmlStreamFactory.getReader(stream);
            this.expect(xmlr, 7);
            TableEntry result = this.parseTableEntry(xmlr);
            this.expect(xmlr, 8);
            return result;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public List<Entity> parseEntityEntries(InputStream stream) {
        try {
            XMLStreamReader xmlr = this.xmlStreamFactory.getReader(stream);
            this.expect(xmlr, 7);
            this.expect(xmlr, 1, "feed");
            ArrayList<Entity> result = new ArrayList<Entity>();
            while (!this.isEndElement(xmlr, "feed")) {
                if (this.isStartElement(xmlr, "entry")) {
                    result.add(this.parseEntityEntry(xmlr));
                    continue;
                }
                this.nextSignificant(xmlr);
            }
            this.expect(xmlr, 2, "feed");
            this.expect(xmlr, 8);
            return result;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    public Entity parseEntityEntry(InputStream stream) {
        try {
            XMLStreamReader xmlr = this.xmlStreamFactory.getReader(stream);
            this.expect(xmlr, 7);
            Entity result = this.parseEntityEntry(xmlr);
            this.expect(xmlr, 8);
            return result;
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private InputStream generateEntry(PropertiesWriter propertiesWriter) {
        try {
            ByteArrayOutputStream stream = new ByteArrayOutputStream();
            XMLStreamWriter writer = this.xmlStreamFactory.getWriter(stream);
            writer.writeStartDocument("utf-8", "1.0");
            writer.writeStartElement("entry");
            writer.writeAttribute("xmlns:d", "http://schemas.microsoft.com/ado/2007/08/dataservices");
            writer.writeAttribute("xmlns:m", "http://schemas.microsoft.com/ado/2007/08/dataservices/metadata");
            writer.writeAttribute("xmlns", "http://www.w3.org/2005/Atom");
            writer.writeStartElement("title");
            writer.writeEndElement();
            writer.writeStartElement("updated");
            writer.writeCharacters(this.iso8601DateConverter.format(this.dateFactory.getDate()));
            writer.writeEndElement();
            writer.writeStartElement("author");
            writer.writeStartElement("name");
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeStartElement("id");
            writer.writeEndElement();
            writer.writeStartElement("content");
            writer.writeAttribute("type", "application/xml");
            writer.writeStartElement("m:properties");
            propertiesWriter.write(writer);
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndElement();
            writer.writeEndDocument();
            writer.close();
            return new ByteArrayInputStream(stream.toByteArray());
        }
        catch (XMLStreamException e) {
            throw new RuntimeException(e);
        }
    }

    private TableEntry parseTableEntry(XMLStreamReader xmlr) throws XMLStreamException {
        TableEntry result = new TableEntry();
        this.expect(xmlr, 1, "entry");
        while (!this.isEndElement(xmlr, "entry")) {
            if (this.isStartElement(xmlr, "properties")) {
                Map<String, Property> properties = this.parseEntryProperties(xmlr);
                result.setName((String)properties.get("TableName").getValue());
                continue;
            }
            this.nextSignificant(xmlr);
        }
        this.expect(xmlr, 2, "entry");
        return result;
    }

    private Entity parseEntityEntry(XMLStreamReader xmlr) throws XMLStreamException {
        Entity result = new Entity();
        result.setEtag(xmlr.getAttributeValue(null, "etag"));
        this.expect(xmlr, 1, "entry");
        while (!this.isEndElement(xmlr, "entry")) {
            if (this.isStartElement(xmlr, "properties")) {
                result.setProperties(this.parseEntryProperties(xmlr));
                continue;
            }
            this.nextSignificant(xmlr);
        }
        this.expect(xmlr, 2, "entry");
        return result;
    }

    private Map<String, Property> parseEntryProperties(XMLStreamReader xmlr) throws XMLStreamException {
        HashMap<String, Property> result = new HashMap<String, Property>();
        this.expect(xmlr, 1, "properties");
        while (!this.isEndElement(xmlr, "properties")) {
            String name = xmlr.getLocalName();
            String edmType = xmlr.getAttributeValue(null, "type");
            xmlr.next();
            String serializedValue = "";
            while (!xmlr.isEndElement()) {
                serializedValue = serializedValue + xmlr.getText();
                xmlr.next();
            }
            Object value = this.edmValueConverter.deserialize(edmType, serializedValue);
            result.put(name, new Property().setEdmType(edmType).setValue(value));
            this.expect(xmlr, 2, name);
        }
        this.expect(xmlr, 2, "properties");
        return result;
    }

    private void nextSignificant(XMLStreamReader xmlr) throws XMLStreamException {
        if (!xmlr.hasNext()) {
            return;
        }
        xmlr.next();
        while (xmlr.isCharacters()) {
            if (!xmlr.hasNext()) {
                return;
            }
            xmlr.next();
        }
    }

    private boolean isStartElement(XMLStreamReader xmlr, String localName) {
        return xmlr.isStartElement() && localName.equals(xmlr.getLocalName());
    }

    private boolean isEndElement(XMLStreamReader xmlr, String localName) {
        return xmlr.isEndElement() && localName.equals(xmlr.getLocalName());
    }

    private void expect(XMLStreamReader xmlr, int eventType) throws XMLStreamException {
        this.expect(xmlr, eventType, null);
    }

    private void expect(XMLStreamReader xmlr, int eventType, String localName) throws XMLStreamException {
        xmlr.require(eventType, null, localName);
        this.nextSignificant(xmlr);
    }

    private String encodeNumericCharacterReference(String value) {
        if (value == null) {
            return null;
        }
        char[] charArray = value.toCharArray();
        StringBuffer stringBuffer = new StringBuffer();
        for (int index = 0; index < charArray.length; ++index) {
            if (this.isIllegalChar(charArray[index])) {
                stringBuffer.append("&#x").append(Integer.toHexString(charArray[index])).append(";");
                continue;
            }
            stringBuffer.append(charArray[index]);
        }
        return stringBuffer.toString();
    }

    private boolean isIllegalChar(char c) {
        return c != '\t' && c != '\n' && c != '\r' && (c < ' ' || c >= '\ufffe');
    }

    private static interface PropertiesWriter {
        public void write(XMLStreamWriter var1) throws XMLStreamException;
    }
}

