/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.ResultContinuation;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.PathUtility;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseRequest;
import com.microsoft.windowsazure.services.table.client.SharedAccessTablePolicy;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableUpdateType;
import java.io.IOException;
import java.io.StringWriter;
import java.net.HttpURLConnection;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

final class TableRequest {
    protected static void applyContinuationToQueryBuilder(UriQueryBuilder builder, ResultContinuation continuationToken) throws StorageException {
        if (continuationToken != null) {
            if (continuationToken.getNextPartitionKey() != null) {
                builder.add("NextPartitionKey", continuationToken.getNextPartitionKey());
            }
            if (continuationToken.getNextRowKey() != null) {
                builder.add("NextRowKey", continuationToken.getNextRowKey());
            }
            if (continuationToken.getNextTableName() != null) {
                builder.add("NextTableName", continuationToken.getNextTableName());
            }
        }
    }

    protected static HttpURLConnection batch(URI rootUri, int timeoutInMs, String batchID, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URI queryUri = PathUtility.appendPathToUri(rootUri, "$batch");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, timeoutInMs, queryBuilder, opContext);
        retConnection.setRequestProperty("Accept", "application/atom+xml,application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF8");
        retConnection.setRequestProperty("MaxDataServiceVersion", "2.0;NetFx");
        retConnection.setRequestProperty("Content-Type", String.format("multipart/mixed; boundary=%s", batchID));
        retConnection.setRequestMethod("POST");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    protected static HttpURLConnection coreCreate(URI rootUri, String tableName, String eTag, String identity, int timeoutInMs, UriQueryBuilder queryBuilder, String requestMethod, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URI queryUri = null;
        queryUri = !Utility.isNullOrEmpty(identity) ? PathUtility.appendPathToUri(rootUri, tableName.concat(String.format("(%s)", identity))) : PathUtility.appendPathToUri(rootUri, tableName);
        HttpURLConnection retConnection = BaseRequest.createURLConnection(queryUri, timeoutInMs, queryBuilder, opContext);
        retConnection.setRequestProperty("Accept", "application/atom+xml,application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF-8");
        retConnection.setRequestProperty("MaxDataServiceVersion", "2.0;NetFx");
        retConnection.setRequestProperty("Content-Type", "application/atom+xml");
        if (!Utility.isNullOrEmpty(eTag)) {
            retConnection.setRequestProperty("If-Match", eTag);
        }
        retConnection.setRequestMethod(requestMethod);
        return retConnection;
    }

    protected static HttpURLConnection delete(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        return TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "DELETE", tableOptions, opContext);
    }

    protected static HttpURLConnection insert(URI rootUri, String tableName, String identity, String eTag, TableUpdateType updateType, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        URLConnection retConnection = null;
        if (updateType == null) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, null, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
        } else if (updateType == TableUpdateType.MERGE) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
            retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        } else if (updateType == TableUpdateType.REPLACE) {
            retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "PUT", tableOptions, opContext);
        }
        retConnection.setDoOutput(true);
        return retConnection;
    }

    protected static HttpURLConnection merge(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "POST", tableOptions, opContext);
        retConnection.setRequestProperty("X-HTTP-Method", "MERGE");
        retConnection.setDoOutput(true);
        return retConnection;
    }

    protected static HttpURLConnection query(URI rootUri, String tableName, String identity, int timeoutInMs, UriQueryBuilder queryBuilder, ResultContinuation continuationToken, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        if (queryBuilder == null) {
            queryBuilder = new UriQueryBuilder();
        }
        TableRequest.applyContinuationToQueryBuilder(queryBuilder, continuationToken);
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, null, identity, timeoutInMs, queryBuilder, "GET", tableOptions, opContext);
        return retConnection;
    }

    protected static HttpURLConnection update(URI rootUri, String tableName, String identity, String eTag, int timeoutInMs, UriQueryBuilder queryBuilder, TableRequestOptions tableOptions, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        HttpURLConnection retConnection = TableRequest.coreCreate(rootUri, tableName, eTag, identity, timeoutInMs, queryBuilder, "PUT", tableOptions, opContext);
        retConnection.setDoOutput(true);
        return retConnection;
    }

    public static HttpURLConnection setAcl(URI rootUri, int timeoutInMs, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, timeoutInMs, queryBuilder, opContext);
        retConnection.setRequestMethod("PUT");
        retConnection.setDoOutput(true);
        retConnection.setRequestProperty("Content-Type", "application/atom+xml");
        return retConnection;
    }

    public static void writeSharedAccessIdentifiersToStream(HashMap<String, SharedAccessTablePolicy> sharedAccessPolicies, StringWriter outWriter) throws XMLStreamException {
        Utility.assertNotNull("sharedAccessPolicies", sharedAccessPolicies);
        Utility.assertNotNull("outWriter", outWriter);
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        if (sharedAccessPolicies.keySet().size() > 5) {
            String errorMessage = String.format("Too many %d shared access policy identifiers provided. Server does not support setting more than %d on a single container.", sharedAccessPolicies.keySet().size(), 5);
            throw new IllegalArgumentException(errorMessage);
        }
        xmlw.writeStartDocument();
        xmlw.writeStartElement("SignedIdentifiers");
        for (Map.Entry<String, SharedAccessTablePolicy> entry : sharedAccessPolicies.entrySet()) {
            SharedAccessTablePolicy policy = entry.getValue();
            xmlw.writeStartElement("SignedIdentifier");
            xmlw.writeStartElement("Id");
            xmlw.writeCharacters(entry.getKey());
            xmlw.writeEndElement();
            xmlw.writeStartElement("AccessPolicy");
            xmlw.writeStartElement("Start");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessStartTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Expiry");
            xmlw.writeCharacters(Utility.getUTCTimeOrEmpty(policy.getSharedAccessExpiryTime()));
            xmlw.writeEndElement();
            xmlw.writeStartElement("Permission");
            xmlw.writeCharacters(SharedAccessTablePolicy.permissionsToString(policy.getPermissions()));
            xmlw.writeEndElement();
            xmlw.writeEndElement();
            xmlw.writeEndElement();
        }
        xmlw.writeEndElement();
        xmlw.writeEndDocument();
    }

    public static HttpURLConnection getAcl(URI rootUri, String tableName, int timeoutInMs, OperationContext opContext) throws IOException, URISyntaxException, StorageException {
        UriQueryBuilder queryBuilder = new UriQueryBuilder();
        queryBuilder.add("comp", "acl");
        HttpURLConnection retConnection = BaseRequest.createURLConnection(rootUri, timeoutInMs, queryBuilder, opContext);
        retConnection.setRequestMethod("GET");
        retConnection.setRequestProperty("Accept", "application/atom+xml,application/xml");
        retConnection.setRequestProperty("Accept-Charset", "UTF8");
        retConnection.setRequestProperty("MaxDataServiceVersion", "2.0;NetFx");
        retConnection.setRequestProperty("Content-Type", "application/atom+xml");
        return retConnection;
    }

    private TableRequest() {
    }
}

