/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.CloudTableClient;
import com.microsoft.windowsazure.services.table.client.EntityResolver;
import com.microsoft.windowsazure.services.table.client.MimeHelper;
import com.microsoft.windowsazure.services.table.client.MimePart;
import com.microsoft.windowsazure.services.table.client.QueryTableOperation;
import com.microsoft.windowsazure.services.table.client.TableEntity;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import com.microsoft.windowsazure.services.table.client.TableOperationType;
import com.microsoft.windowsazure.services.table.client.TableRequest;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableResult;
import com.microsoft.windowsazure.services.table.client.TableServiceException;
import java.io.InputStream;
import java.io.StringReader;
import java.net.HttpURLConnection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.UUID;
import javax.xml.stream.XMLStreamReader;

public class TableBatchOperation
extends ArrayList<TableOperation> {
    private static final long serialVersionUID = -1192644463287355790L;
    private boolean hasQuery = false;
    private String partitionKey = null;

    @Override
    public void add(int index, TableOperation element) {
        Utility.assertNotNull("element", element);
        this.checkSingleQueryPerBatch(element);
        if (element.getOperationType() == TableOperationType.RETRIEVE) {
            this.lockToPartitionKey(((QueryTableOperation)element).getPartitionKey());
        } else {
            this.lockToPartitionKey(element.getEntity().getPartitionKey());
        }
        super.add(index, element);
    }

    @Override
    public boolean add(TableOperation element) {
        Utility.assertNotNull("element", element);
        this.checkSingleQueryPerBatch(element);
        if (element.getEntity() == null) {
            this.lockToPartitionKey(((QueryTableOperation)element).getPartitionKey());
        } else {
            this.lockToPartitionKey(element.getEntity().getPartitionKey());
        }
        return super.add(element);
    }

    @Override
    public boolean addAll(int index, Collection<? extends TableOperation> c) {
        for (TableOperation tableOperation : c) {
            Utility.assertNotNull("operation", tableOperation);
            this.checkSingleQueryPerBatch(tableOperation);
            if (tableOperation.getEntity() == null) {
                this.lockToPartitionKey(((QueryTableOperation)tableOperation).getPartitionKey());
                continue;
            }
            this.lockToPartitionKey(tableOperation.getEntity().getPartitionKey());
        }
        return super.addAll(index, c);
    }

    @Override
    public boolean addAll(Collection<? extends TableOperation> c) {
        for (TableOperation tableOperation : c) {
            Utility.assertNotNull("operation", tableOperation);
            this.checkSingleQueryPerBatch(tableOperation);
            if (tableOperation.getEntity() == null) {
                this.lockToPartitionKey(((QueryTableOperation)tableOperation).getPartitionKey());
                continue;
            }
            this.lockToPartitionKey(tableOperation.getEntity().getPartitionKey());
        }
        return super.addAll(c);
    }

    @Override
    public void clear() {
        super.clear();
        this.checkResetEntityLocks();
    }

    public void delete(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.delete(entity));
    }

    public void insert(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insert(entity));
    }

    public void insertOrMerge(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insertOrMerge(entity));
    }

    public void insertOrReplace(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.insertOrReplace(entity));
    }

    public void merge(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.merge(entity));
    }

    public void retrieve(String partitionKey, String rowKey, Class<? extends TableEntity> clazzType) {
        this.lockToPartitionKey(partitionKey);
        this.add(TableOperation.retrieve(partitionKey, rowKey, clazzType));
    }

    public void retrieve(String partitionKey, String rowKey, EntityResolver<?> resolver) {
        this.lockToPartitionKey(partitionKey);
        this.add(TableOperation.retrieve(partitionKey, rowKey, resolver));
    }

    @Override
    public TableOperation remove(int index) {
        TableOperation op = (TableOperation)super.remove(index);
        this.checkResetEntityLocks();
        return op;
    }

    @Override
    public boolean remove(Object o) {
        boolean ret = super.remove(o);
        this.checkResetEntityLocks();
        return ret;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean ret = super.removeAll(c);
        this.checkResetEntityLocks();
        return ret;
    }

    public void replace(TableEntity entity) {
        this.lockToPartitionKey(entity.getPartitionKey());
        this.add(TableOperation.replace(entity));
    }

    private void checkResetEntityLocks() {
        if (this.size() == 0) {
            this.partitionKey = null;
            this.hasQuery = false;
        }
    }

    private void checkSingleQueryPerBatch(TableOperation op) {
        if (this.hasQuery) {
            throw new IllegalArgumentException("A batch transaction with a retrieve operation cannot contain any other operations.");
        }
        if (op.opType == TableOperationType.RETRIEVE) {
            if (this.size() > 0) {
                throw new IllegalArgumentException("A batch transaction with a retrieve operation cannot contain any other operations.");
            }
            this.hasQuery = true;
        }
    }

    private void lockToPartitionKey(String partitionKey) {
        if (this.partitionKey == null) {
            this.partitionKey = partitionKey;
        } else if (partitionKey.length() != partitionKey.length() || !this.partitionKey.equals(partitionKey)) {
            throw new IllegalArgumentException("All entities in a given batch must have the same partition key.");
        }
    }

    protected ArrayList<TableResult> execute(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        Utility.assertNotNullOrEmpty("TableName", tableName);
        if (this.size() == 0) {
            throw new IllegalArgumentException("Cannot Execute an empty batch operation");
        }
        StorageOperation<CloudTableClient, TableBatchOperation, ArrayList<TableResult>> impl = new StorageOperation<CloudTableClient, TableBatchOperation, ArrayList<TableResult>>((RequestOptions)options){

            @Override
            public ArrayList<TableResult> execute(CloudTableClient client, TableBatchOperation batch, OperationContext opContext) throws Exception {
                String batchID = String.format("batch_%s", UUID.randomUUID().toString());
                String changeSet = String.format("changeset_%s", UUID.randomUUID().toString());
                HttpURLConnection request = TableRequest.batch(client.getTransformedEndPoint(opContext), options.getTimeoutIntervalInMs(), batchID, null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                MimeHelper.writeBatchToStream(request.getOutputStream(), tableName, batch, batchID, changeSet, opContext);
                InputStream streamRef = ExecutionEngine.getInputStream(request, opContext, this.getResult());
                ArrayList<MimePart> responseParts = null;
                String contentType = request.getHeaderField("Content-Type");
                String[] headerVals = contentType.split("multipart/mixed; boundary=");
                if (headerVals == null || headerVals.length != 2) {
                    throw new StorageException("OutOfRangeInput", "An incorrect Content-type was returned from the server.", 306, null, null);
                }
                responseParts = MimeHelper.readBatchResponseStream(streamRef, headerVals[1], opContext);
                ExecutionEngine.getResponseCode(this.getResult(), request, opContext);
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                ArrayList<TableResult> result = new ArrayList<TableResult>();
                for (int m = 0; m < batch.size(); ++m) {
                    TableOperation currOp = (TableOperation)batch.get(m);
                    MimePart currMimePart = responseParts.get(m);
                    boolean failFlag = false;
                    if (currOp.opType == TableOperationType.INSERT) {
                        if (this.getResult().getStatusCode() == 409) {
                            throw new TableServiceException(currMimePart.httpStatusCode, currMimePart.httpStatusMessage, currOp, new StringReader(currMimePart.payload));
                        }
                        if (currMimePart.httpStatusCode != 201) {
                            failFlag = true;
                        }
                    } else if (currOp.opType == TableOperationType.RETRIEVE) {
                        if (currMimePart.httpStatusCode == 404) {
                            result.add(new TableResult(currMimePart.httpStatusCode));
                            return result;
                        }
                        if (currMimePart.httpStatusCode != 200) {
                            failFlag = true;
                        }
                    } else {
                        if (currMimePart.httpStatusCode == 404) {
                            throw new TableServiceException(currMimePart.httpStatusCode, currMimePart.httpStatusMessage, currOp, new StringReader(currMimePart.payload));
                        }
                        if (currMimePart.httpStatusCode != 204) {
                            failFlag = true;
                        }
                    }
                    if (failFlag) {
                        TableServiceException potentiallyRetryableException = new TableServiceException(currMimePart.httpStatusCode, currMimePart.httpStatusMessage, currOp, new StringReader(currMimePart.payload));
                        potentiallyRetryableException.setRetryable(true);
                        throw potentiallyRetryableException;
                    }
                    XMLStreamReader xmlr = null;
                    if (currOp.opType == TableOperationType.INSERT || currOp.opType == TableOperationType.RETRIEVE) {
                        xmlr = Utility.createXMLStreamReaderFromReader(new StringReader(currMimePart.payload));
                    }
                    result.add(currOp.parseResponse(xmlr, currMimePart.httpStatusCode, currMimePart.headers.get("ETag"), opContext));
                }
                return result;
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    @Override
    protected void removeRange(int fromIndex, int toIndex) {
        super.removeRange(fromIndex, toIndex);
        this.checkResetEntityLocks();
    }
}

