/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.table.client.SharedAccessTablePermissions;
import java.util.Date;
import java.util.EnumSet;

public final class SharedAccessTablePolicy {
    private EnumSet<SharedAccessTablePermissions> permissions;
    private Date sharedAccessExpiryTime;
    private Date sharedAccessStartTime;

    public static EnumSet<SharedAccessTablePermissions> permissionsFromString(String value) {
        char[] chars = value.toCharArray();
        EnumSet<SharedAccessTablePermissions> retSet = EnumSet.noneOf(SharedAccessTablePermissions.class);
        block6: for (char c : chars) {
            switch (c) {
                case 'r': {
                    retSet.add(SharedAccessTablePermissions.QUERY);
                    continue block6;
                }
                case 'a': {
                    retSet.add(SharedAccessTablePermissions.ADD);
                    continue block6;
                }
                case 'u': {
                    retSet.add(SharedAccessTablePermissions.UPDATE);
                    continue block6;
                }
                case 'd': {
                    retSet.add(SharedAccessTablePermissions.DELETE);
                    continue block6;
                }
                default: {
                    throw new IllegalArgumentException("value");
                }
            }
        }
        return retSet;
    }

    public static String permissionsToString(EnumSet<SharedAccessTablePermissions> permissions) {
        if (permissions == null) {
            return "";
        }
        StringBuilder builder = new StringBuilder();
        if (permissions.contains((Object)SharedAccessTablePermissions.QUERY)) {
            builder.append("r");
        }
        if (permissions.contains((Object)SharedAccessTablePermissions.ADD)) {
            builder.append("a");
        }
        if (permissions.contains((Object)SharedAccessTablePermissions.UPDATE)) {
            builder.append("u");
        }
        if (permissions.contains((Object)SharedAccessTablePermissions.DELETE)) {
            builder.append("d");
        }
        return builder.toString();
    }

    public EnumSet<SharedAccessTablePermissions> getPermissions() {
        return this.permissions;
    }

    public Date getSharedAccessExpiryTime() {
        return this.sharedAccessExpiryTime;
    }

    public Date getSharedAccessStartTime() {
        return this.sharedAccessStartTime;
    }

    public void setPermissions(EnumSet<SharedAccessTablePermissions> permissions) {
        this.permissions = permissions;
    }

    public void setSharedAccessExpiryTime(Date sharedAccessExpiryTime) {
        this.sharedAccessExpiryTime = sharedAccessExpiryTime;
    }

    public void setSharedAccessStartTime(Date sharedAccessStartTime) {
        this.sharedAccessStartTime = sharedAccessStartTime;
    }
}

