/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.AtomPubParser;
import com.microsoft.windowsazure.services.table.client.CloudTableClient;
import com.microsoft.windowsazure.services.table.client.EntityResolver;
import com.microsoft.windowsazure.services.table.client.TableEntity;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import com.microsoft.windowsazure.services.table.client.TableOperationType;
import com.microsoft.windowsazure.services.table.client.TableRequest;
import com.microsoft.windowsazure.services.table.client.TableRequestOptions;
import com.microsoft.windowsazure.services.table.client.TableResult;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.text.ParseException;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public class QueryTableOperation
extends TableOperation {
    private EntityResolver<?> resolver;
    private Class<? extends TableEntity> clazzType;
    private String partitionKey;
    private String rowKey;

    protected QueryTableOperation() {
        super(null, TableOperationType.RETRIEVE);
    }

    QueryTableOperation(String partitionKey, String rowKey) {
        super(null, TableOperationType.RETRIEVE);
        Utility.assertNotNull("partitionKey", partitionKey);
        this.partitionKey = partitionKey;
        this.rowKey = rowKey;
    }

    public String getPartitionKey() {
        return this.partitionKey;
    }

    public EntityResolver<?> getResolver() {
        return this.resolver;
    }

    public String getRowKey() {
        return this.rowKey;
    }

    protected Class<? extends TableEntity> getClazzType() {
        return this.clazzType;
    }

    @Override
    protected TableResult parseResponse(XMLStreamReader xmlr, int httpStatusCode, String etagFromHeader, OperationContext opContext) throws XMLStreamException, ParseException, InstantiationException, IllegalAccessException, StorageException {
        return AtomPubParser.parseSingleOpResponse(xmlr, httpStatusCode, this.getClazzType(), this.getResolver(), opContext);
    }

    protected TableResult performRetrieve(CloudTableClient client, final String tableName, final TableRequestOptions options, OperationContext opContext) throws StorageException {
        final boolean isTableEntry = "Tables".equals(tableName);
        if (this.getClazzType() != null) {
            Utility.checkNullaryCtor(this.getClazzType());
        } else {
            Utility.assertNotNull("Query requires a valid class type or resolver.", this.getResolver());
        }
        StorageOperation<CloudTableClient, QueryTableOperation, TableResult> impl = new StorageOperation<CloudTableClient, QueryTableOperation, TableResult>((RequestOptions)options){

            @Override
            public TableResult execute(CloudTableClient client, QueryTableOperation operation, OperationContext opContext) throws Exception {
                HttpURLConnection request = TableRequest.query(client.getTransformedEndPoint(opContext), tableName, QueryTableOperation.this.generateRequestIdentity(isTableEntry, operation.getPartitionKey(), false), options.getTimeoutIntervalInMs(), null, null, options, opContext);
                this.setConnection(request);
                this.signTableRequest(client, request, -1L, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() == 200) {
                    InputStream inStream = request.getInputStream();
                    XMLStreamReader xmlr = Utility.createXMLStreamReaderFromStream(inStream);
                    TableResult res = null;
                    res = AtomPubParser.parseSingleOpResponse(xmlr, this.getResult().getStatusCode(), operation.getClazzType(), operation.getResolver(), opContext);
                    return res;
                }
                if (this.getResult().getStatusCode() == 404) {
                    return new TableResult(this.getResult().getStatusCode());
                }
                this.setNonExceptionedRetryableFailure(true);
                return null;
            }
        };
        return ExecutionEngine.executeWithRetry(client, this, impl, options.getRetryPolicyFactory(), opContext);
    }

    protected void setClazzType(Class<? extends TableEntity> clazzType) {
        Utility.assertNotNull("clazzType", clazzType);
        Utility.checkNullaryCtor(clazzType);
        this.clazzType = clazzType;
    }

    protected void setPartitionKey(String partitionKey) {
        this.partitionKey = partitionKey;
    }

    protected void setResolver(EntityResolver<?> resolver) {
        Utility.assertNotNull("Query requires a valid class type or resolver.", resolver);
        this.resolver = resolver;
    }

    protected void setRowKey(String rowKey) {
        this.rowKey = rowKey;
    }
}

