/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.table.client.AtomPubParser;
import com.microsoft.windowsazure.services.table.client.MimeHeader;
import com.microsoft.windowsazure.services.table.client.MimePart;
import com.microsoft.windowsazure.services.table.client.QueryTableOperation;
import com.microsoft.windowsazure.services.table.client.TableBatchOperation;
import com.microsoft.windowsazure.services.table.client.TableOperation;
import com.microsoft.windowsazure.services.table.client.TableOperationType;
import com.microsoft.windowsazure.services.table.client.TableServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringWriter;
import java.net.URISyntaxException;
import java.util.ArrayList;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;

class MimeHelper {
    MimeHelper() {
    }

    protected static StorageException generateMimeParseException() {
        return new StorageException("OutOfRangeInput", "Invalid MIME response received.", 306, null, null);
    }

    protected static String getHttpVerbForOperation(TableOperation operation) {
        if (operation.getOperationType() == TableOperationType.INSERT) {
            return "POST";
        }
        if (operation.getOperationType() == TableOperationType.DELETE) {
            return "DELETE";
        }
        if (operation.getOperationType() == TableOperationType.MERGE || operation.getOperationType() == TableOperationType.INSERT_OR_MERGE) {
            return "MERGE";
        }
        if (operation.getOperationType() == TableOperationType.REPLACE || operation.getOperationType() == TableOperationType.INSERT_OR_REPLACE) {
            return "PUT";
        }
        if (operation.getOperationType() == TableOperationType.RETRIEVE) {
            return "GET";
        }
        throw new IllegalArgumentException("Unknown table operation");
    }

    protected static String getNextLineSkippingBlankLines(BufferedReader reader) throws IOException {
        String tString = null;
        while ((tString = reader.readLine()) != null && tString.length() == 0) {
        }
        return tString;
    }

    protected static ArrayList<MimePart> readBatchResponseStream(InputStream inStream, String expectedBundaryName, OperationContext opContext) throws IOException, StorageException {
        ArrayList<MimePart> result = new ArrayList<MimePart>();
        InputStreamReader streamReader = new InputStreamReader(inStream, "UTF-8");
        BufferedReader reader = new BufferedReader(streamReader);
        String mungedExpectedBoundaryName = "--".concat(expectedBundaryName);
        MimeHeader docHeader = MimeHelper.readMimeHeader(reader, opContext);
        if (docHeader.boundary == null || !docHeader.boundary.equals(mungedExpectedBoundaryName)) {
            throw MimeHelper.generateMimeParseException();
        }
        MimeHeader currHeader = null;
        if (docHeader.subBoundary == null) {
            do {
                result.add(MimeHelper.readMimePart(reader, docHeader.boundary, opContext));
            } while ((currHeader = MimeHelper.readMimeHeader(reader, opContext)) != null);
        } else {
            currHeader = MimeHelper.readMimeHeader(reader, opContext);
            if (currHeader == null) {
                throw new TableServiceException(-1, "An Error Occurred while processing the request, check the extended error information for more details.", null, reader);
            }
            do {
                result.add(MimeHelper.readMimePart(reader, docHeader.subBoundary, opContext));
            } while ((currHeader = MimeHelper.readMimeHeader(reader, opContext)) != null);
        }
        return result;
    }

    protected static MimeHeader readMimeHeader(BufferedReader reader, OperationContext opContext) throws IOException, StorageException {
        String tempString;
        MimeHeader retHeader = new MimeHeader();
        reader.mark(0x100000);
        retHeader.boundary = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (retHeader.boundary.endsWith("--")) {
            return null;
        }
        if (!retHeader.boundary.startsWith("--")) {
            reader.reset();
            return null;
        }
        for (int m = 0; m < 2 && (tempString = reader.readLine()).length() != 0; ++m) {
            String[] headerVals;
            if (tempString.startsWith("Content-Type:")) {
                headerVals = tempString.split("Content-Type: ");
                if (headerVals == null || headerVals.length != 2) {
                    throw MimeHelper.generateMimeParseException();
                }
                retHeader.contentType = headerVals[1];
                continue;
            }
            if (tempString.startsWith("Content-Transfer-Encoding:")) {
                headerVals = tempString.split("Content-Transfer-Encoding: ");
                if (headerVals == null || headerVals.length != 2) {
                    throw MimeHelper.generateMimeParseException();
                }
                retHeader.contentTransferEncoding = headerVals[1];
                continue;
            }
            throw MimeHelper.generateMimeParseException();
        }
        if (Utility.isNullOrEmpty(retHeader.boundary) || retHeader.contentType == null) {
            throw MimeHelper.generateMimeParseException();
        }
        if (retHeader.contentType.startsWith("multipart/mixed; boundary=")) {
            String[] headerVals = retHeader.contentType.split("multipart/mixed; boundary=");
            if (headerVals == null || headerVals.length != 2) {
                throw MimeHelper.generateMimeParseException();
            }
            retHeader.subBoundary = "--".concat(headerVals[1]);
        } else if (!retHeader.contentType.equals("application/http")) {
            throw MimeHelper.generateMimeParseException();
        }
        if (retHeader.contentTransferEncoding != null && !retHeader.contentTransferEncoding.equals("binary")) {
            throw MimeHelper.generateMimeParseException();
        }
        return retHeader;
    }

    protected static MimePart readMimePart(BufferedReader reader, String boundary, OperationContext opContext) throws IOException, StorageException {
        MimePart retPart = new MimePart();
        String tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (!tempStr.startsWith("HTTP/1.1 ")) {
            throw MimeHelper.generateMimeParseException();
        }
        String[] headerVals = tempStr.split(" ");
        if (headerVals.length < 3) {
            throw MimeHelper.generateMimeParseException();
        }
        retPart.httpStatusCode = Integer.parseInt(headerVals[1]);
        retPart.httpStatusMessage = tempStr.substring(13);
        tempStr = reader.readLine();
        while (tempStr != null && tempStr.length() > 0) {
            String[] headerParts = tempStr.split(": ");
            if (headerParts.length < 2) {
                throw MimeHelper.generateMimeParseException();
            }
            retPart.headers.put(headerParts[0], headerParts[1]);
            tempStr = reader.readLine();
        }
        reader.mark(0x100000);
        tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
        if (tempStr == null) {
            throw MimeHelper.generateMimeParseException();
        }
        if (tempStr.startsWith(boundary)) {
            reader.reset();
            retPart.payload = "";
            return retPart;
        }
        if (!tempStr.startsWith("<?xml version=")) {
            throw MimeHelper.generateMimeParseException();
        }
        StringBuilder payloadBuilder = new StringBuilder();
        while (!tempStr.startsWith(boundary)) {
            payloadBuilder.append(tempStr);
            reader.mark(0x100000);
            tempStr = MimeHelper.getNextLineSkippingBlankLines(reader);
            if (tempStr != null) continue;
            throw MimeHelper.generateMimeParseException();
        }
        reader.reset();
        retPart.payload = payloadBuilder.toString();
        return retPart;
    }

    protected static void writeBatchToStream(OutputStream outStream, String tableName, TableBatchOperation batch, String batchID, String changeSet, OperationContext opContext) throws IOException, URISyntaxException, StorageException, XMLStreamException {
        OutputStreamWriter outWriter = new OutputStreamWriter(outStream, "UTF8");
        int contentID = 0;
        boolean inChangeSet = false;
        for (TableOperation op : batch) {
            if (op.getOperationType() == TableOperationType.RETRIEVE) {
                QueryTableOperation qOp = (QueryTableOperation)op;
                if (inChangeSet) {
                    inChangeSet = false;
                    MimeHelper.writeMIMEBoundaryClosure(outWriter, changeSet);
                    outWriter.write("\r\n");
                }
                MimeHelper.writeMIMEBoundary(outWriter, batchID);
                outWriter.write("Content-Type: application/http\r\n");
                outWriter.write("Content-Transfer-Encoding: binary\r\n\r\n");
                outWriter.write(String.format("%s %s HTTP/1.1\r\n", MimeHelper.getHttpVerbForOperation(op), qOp.generateRequestIdentityWithTable(tableName)));
                outWriter.write("Host: host\r\n\r\n");
                continue;
            }
            if (!inChangeSet) {
                inChangeSet = true;
                MimeHelper.writeMIMEBoundary(outWriter, batchID);
                MimeHelper.writeMIMEContentType(outWriter, changeSet);
                outWriter.write("\r\n");
            }
            MimeHelper.writeMIMEBoundary(outWriter, changeSet);
            outWriter.write("Content-Type: application/http\r\n");
            outWriter.write("Content-Transfer-Encoding: binary\r\n\r\n");
            outWriter.write(String.format("%s %s HTTP/1.1\r\n", MimeHelper.getHttpVerbForOperation(op), op.generateRequestIdentityWithTable(tableName)));
            outWriter.write(String.format("Content-ID: %s\r\n", Integer.toString(contentID)));
            if (op.getOperationType() != TableOperationType.INSERT && op.getOperationType() != TableOperationType.INSERT_OR_MERGE && op.getOperationType() != TableOperationType.INSERT_OR_REPLACE) {
                outWriter.write(String.format("If-Match: %s\r\n", op.getEntity().getEtag()));
            }
            if (op.getOperationType() == TableOperationType.DELETE) {
                outWriter.write("\r\n");
            } else {
                outWriter.write("Content-Type: application/atom+xml;type=entry\r\n");
                String opString = MimeHelper.writeStringForOperation(op, opContext);
                outWriter.write(String.format("Content-Length: %s\r\n\r\n", Integer.toString(opString.getBytes("UTF-8").length)));
                outWriter.write(opString);
            }
            ++contentID;
        }
        if (inChangeSet) {
            MimeHelper.writeMIMEBoundaryClosure(outWriter, changeSet);
        }
        MimeHelper.writeMIMEBoundaryClosure(outWriter, batchID);
        outWriter.flush();
    }

    protected static void writeMIMEBoundary(OutputStreamWriter outWriter, String boundaryID) throws IOException {
        outWriter.write(String.format("--%s\r\n", boundaryID));
    }

    protected static void writeMIMEBoundaryClosure(OutputStreamWriter outWriter, String boundaryID) throws IOException {
        outWriter.write(String.format("--%s--\r\n", boundaryID));
    }

    protected static void writeMIMEContentType(OutputStreamWriter outWriter, String boundaryName) throws IOException {
        outWriter.write(String.format("Content-Type: multipart/mixed; boundary=%s\r\n", boundaryName));
    }

    protected static String writeStringForOperation(TableOperation operation, OperationContext opContext) throws StorageException, XMLStreamException {
        StringWriter outWriter = new StringWriter();
        XMLOutputFactory xmlOutFactoryInst = XMLOutputFactory.newInstance();
        XMLStreamWriter xmlw = xmlOutFactoryInst.createXMLStreamWriter(outWriter);
        AtomPubParser.writeSingleEntityToStream(operation.getEntity(), false, xmlw, opContext);
        outWriter.write("\r\n");
        return outWriter.toString();
    }
}

