/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

import com.microsoft.windowsazure.services.core.storage.utils.Base64;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.table.client.EdmType;
import java.text.ParseException;
import java.util.Date;
import java.util.UUID;

public final class EntityProperty {
    private String value;
    private EdmType edmType = EdmType.NULL;
    private boolean isNull = false;

    public EntityProperty(boolean value) {
        this.setValue(value);
    }

    public EntityProperty(byte[] value) {
        this.setValue(value);
    }

    public EntityProperty(Byte[] value) {
        this.setValue(value);
    }

    public EntityProperty(Date value) {
        this.setValue(value);
    }

    public EntityProperty(double value) {
        this.setValue(value);
    }

    public EntityProperty(int value) {
        this.setValue(value);
    }

    public EntityProperty(long value) {
        this.setValue(value);
    }

    public EntityProperty(String value) {
        this.setValue(value);
    }

    protected EntityProperty(String value, EdmType edmType) throws ParseException {
        this.edmType = edmType;
        this.value = value;
        if (edmType == EdmType.STRING) {
            return;
        }
        if (edmType == EdmType.BINARY) {
            this.getValueAsByteArray();
        } else if (edmType == EdmType.BOOLEAN) {
            this.getValueAsBoolean();
        } else if (edmType == EdmType.DOUBLE) {
            this.getValueAsDouble();
        } else if (edmType == EdmType.GUID) {
            this.getValueAsUUID();
        } else if (edmType == EdmType.INT32) {
            this.getValueAsInteger();
        } else if (edmType == EdmType.INT64) {
            this.getValueAsLong();
        } else if (edmType == EdmType.DATE_TIME) {
            this.getValueAsDate();
        }
    }

    public EntityProperty(UUID value) {
        this.setValue(value);
    }

    protected EntityProperty(EdmType type) {
        this.value = null;
        this.edmType = type;
        this.isNull = true;
    }

    public EdmType getEdmType() {
        return this.edmType;
    }

    public boolean getIsNull() {
        return this.isNull;
    }

    public boolean getValueAsBoolean() {
        if (this.isNull) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for value types.");
        }
        return Boolean.parseBoolean(this.value);
    }

    public byte[] getValueAsByteArray() {
        return this.isNull ? null : Base64.decode(this.value);
    }

    public Byte[] getValueAsByteObjectArray() {
        return this.isNull ? null : Base64.decodeAsByteObjectArray(this.value);
    }

    public Date getValueAsDate() {
        if (this.isNull) {
            return null;
        }
        return Utility.parseDate(this.value);
    }

    public double getValueAsDouble() {
        if (this.isNull) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for value types.");
        }
        return Double.parseDouble(this.value);
    }

    public int getValueAsInteger() {
        if (this.isNull) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for value types.");
        }
        return Integer.parseInt(this.value);
    }

    public long getValueAsLong() {
        if (this.isNull) {
            throw new IllegalArgumentException("EntityProperty cannot be set to null for value types.");
        }
        return Long.parseLong(this.value);
    }

    public String getValueAsString() {
        return this.isNull ? null : this.value;
    }

    public UUID getValueAsUUID() {
        return this.isNull ? null : UUID.fromString(this.value);
    }

    public final synchronized void setValue(boolean value) {
        this.edmType = EdmType.BOOLEAN;
        this.isNull = false;
        this.value = value ? "true" : "false";
    }

    public final synchronized void setValue(byte[] value) {
        this.edmType = EdmType.BINARY;
        if (value == null) {
            this.value = null;
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.value = Base64.encode(value);
    }

    public final synchronized void setValue(Byte[] value) {
        this.edmType = EdmType.BINARY;
        if (value == null) {
            this.value = null;
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.value = Base64.encode(value);
    }

    public final synchronized void setValue(Date value) {
        this.edmType = EdmType.DATE_TIME;
        if (value == null) {
            this.value = null;
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.value = Utility.getTimeByZoneAndFormat(value, Utility.UTC_ZONE, "yyyy-MM-dd'T'HH:mm:ss.SSSSSSS'Z'");
    }

    public final synchronized void setValue(double value) {
        this.edmType = EdmType.DOUBLE;
        this.isNull = false;
        this.value = Double.toString(value);
    }

    public final synchronized void setValue(int value) {
        this.edmType = EdmType.INT32;
        this.isNull = false;
        this.value = Integer.toString(value);
    }

    public final synchronized void setValue(long value) {
        this.edmType = EdmType.INT64;
        this.isNull = false;
        this.value = Long.toString(value);
    }

    public final synchronized void setValue(String value) {
        this.edmType = EdmType.STRING;
        if (value == null) {
            this.value = null;
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.value = value;
    }

    public final synchronized void setValue(UUID value) {
        this.edmType = EdmType.GUID;
        if (value == null) {
            this.value = null;
            this.isNull = true;
            return;
        }
        this.isNull = false;
        this.value = value.toString();
    }

    protected void setIsNull(boolean isNull) {
        this.isNull = isNull;
    }
}

