/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.table.client;

public enum EdmType {
    NULL,
    BINARY,
    BOOLEAN,
    BYTE,
    DATE_TIME,
    DECIMAL,
    DOUBLE,
    SINGLE,
    GUID,
    INT16,
    INT32,
    INT64,
    SBYTE,
    STRING,
    TIME,
    DATE_TIME_OFFSET;


    public static EdmType parse(String value) {
        if (value == null || value.length() == 0) {
            return STRING;
        }
        if (value.equals("Edm.DateTime")) {
            return DATE_TIME;
        }
        if (value.equals("Edm.Int32")) {
            return INT32;
        }
        if (value.equals("Edm.Boolean")) {
            return BOOLEAN;
        }
        if (value.equals("Edm.Double")) {
            return DOUBLE;
        }
        if (value.equals("Edm.Int64")) {
            return INT64;
        }
        if (value.equals("Edm.Guid")) {
            return GUID;
        }
        if (value.equals("Edm.Binary")) {
            return BINARY;
        }
        throw new IllegalArgumentException("Invalid value for edmtype: ".concat(value));
    }

    public String toString() {
        if (this == BINARY) {
            return "Edm.Binary";
        }
        if (this == STRING) {
            return "";
        }
        if (this == BOOLEAN) {
            return "Edm.Boolean";
        }
        if (this == DOUBLE) {
            return "Edm.Double";
        }
        if (this == GUID) {
            return "Edm.Guid";
        }
        if (this == INT32) {
            return "Edm.Int32";
        }
        if (this == INT64) {
            return "Edm.Int64";
        }
        if (this == DATE_TIME) {
            return "Edm.DateTime";
        }
        return "";
    }
}

