/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.serviceBus.models;

import com.microsoft.windowsazure.services.serviceBus.implementation.Content;
import com.microsoft.windowsazure.services.serviceBus.implementation.EntityAvailabilityStatus;
import com.microsoft.windowsazure.services.serviceBus.implementation.EntityStatus;
import com.microsoft.windowsazure.services.serviceBus.implementation.Entry;
import com.microsoft.windowsazure.services.serviceBus.implementation.EntryModel;
import com.microsoft.windowsazure.services.serviceBus.implementation.MessageCountDetails;
import com.microsoft.windowsazure.services.serviceBus.implementation.PartitioningPolicy;
import com.microsoft.windowsazure.services.serviceBus.implementation.QueueDescription;
import java.net.URI;
import java.util.Calendar;
import javax.xml.datatype.Duration;

public class QueueInfo
extends EntryModel<QueueDescription> {
    public QueueInfo() {
        super(new Entry(), new QueueDescription());
        this.getEntry().setContent(new Content());
        this.getEntry().getContent().setType("application/xml");
        this.getEntry().getContent().setQueueDescription((QueueDescription)this.getModel());
    }

    public QueueInfo(Entry entry) {
        super(entry, entry.getContent().getQueueDescription());
    }

    public QueueInfo(String path) {
        this();
        this.setPath(path);
    }

    public String getPath() {
        return this.getEntry().getTitle();
    }

    public QueueInfo setPath(String value) {
        this.getEntry().setTitle(value);
        return this;
    }

    public Duration getLockDuration() {
        return ((QueueDescription)this.getModel()).getLockDuration();
    }

    public QueueInfo setLockDuration(Duration value) {
        ((QueueDescription)this.getModel()).setLockDuration(value);
        return this;
    }

    public Long getMaxSizeInMegabytes() {
        return ((QueueDescription)this.getModel()).getMaxSizeInMegabytes();
    }

    public QueueInfo setMaxSizeInMegabytes(Long value) {
        ((QueueDescription)this.getModel()).setMaxSizeInMegabytes(value);
        return this;
    }

    public Boolean isRequiresDuplicateDetection() {
        return ((QueueDescription)this.getModel()).isRequiresDuplicateDetection();
    }

    public QueueInfo setRequiresDuplicateDetection(Boolean value) {
        ((QueueDescription)this.getModel()).setRequiresDuplicateDetection(value);
        return this;
    }

    public Boolean isRequiresSession() {
        return ((QueueDescription)this.getModel()).isRequiresSession();
    }

    public QueueInfo setRequiresSession(Boolean value) {
        ((QueueDescription)this.getModel()).setRequiresSession(value);
        return this;
    }

    public Duration getDefaultMessageTimeToLive() {
        return ((QueueDescription)this.getModel()).getDefaultMessageTimeToLive();
    }

    public QueueInfo setDefaultMessageTimeToLive(Duration value) {
        ((QueueDescription)this.getModel()).setDefaultMessageTimeToLive(value);
        return this;
    }

    public Duration getAutoDeleteOnIdle() {
        return ((QueueDescription)this.getModel()).getAutoDeleteOnIdle();
    }

    public QueueInfo setAutoDeleteOnIdle(Duration autoDeleteOnIdle) {
        ((QueueDescription)this.getModel()).setAutoDeleteOnIdle(autoDeleteOnIdle);
        return this;
    }

    public Boolean isDeadLetteringOnMessageExpiration() {
        return ((QueueDescription)this.getModel()).isDeadLetteringOnMessageExpiration();
    }

    public QueueInfo setDeadLetteringOnMessageExpiration(Boolean value) {
        ((QueueDescription)this.getModel()).setDeadLetteringOnMessageExpiration(value);
        return this;
    }

    public Duration getDuplicateDetectionHistoryTimeWindow() {
        return ((QueueDescription)this.getModel()).getDuplicateDetectionHistoryTimeWindow();
    }

    public QueueInfo setDuplicateDetectionHistoryTimeWindow(Duration value) {
        ((QueueDescription)this.getModel()).setDuplicateDetectionHistoryTimeWindow(value);
        return this;
    }

    public Integer getMaxDeliveryCount() {
        return ((QueueDescription)this.getModel()).getMaxDeliveryCount();
    }

    public QueueInfo setMaxDeliveryCount(Integer value) {
        ((QueueDescription)this.getModel()).setMaxDeliveryCount(value);
        return this;
    }

    public Boolean isEnableBatchedOperations() {
        return ((QueueDescription)this.getModel()).isEnableBatchedOperations();
    }

    public QueueInfo setEnableBatchedOperations(Boolean value) {
        ((QueueDescription)this.getModel()).setEnableBatchedOperations(value);
        return this;
    }

    public Long getSizeInBytes() {
        return ((QueueDescription)this.getModel()).getSizeInBytes();
    }

    public QueueInfo setSizeInBytes(Long sizeInBytes) {
        ((QueueDescription)this.getModel()).setSizeInBytes(sizeInBytes);
        return this;
    }

    public Long getMessageCount() {
        return ((QueueDescription)this.getModel()).getMessageCount();
    }

    public QueueInfo setMessageCount(Long messageCount) {
        ((QueueDescription)this.getModel()).setMessageCount(messageCount);
        return this;
    }

    public Boolean isAnonymousAccessible() {
        return ((QueueDescription)this.getModel()).isIsAnonymousAccessible();
    }

    public QueueInfo setIsAnonymousAccessible(Boolean isAnonymousAccessible) {
        ((QueueDescription)this.getModel()).setIsAnonymousAccessible(isAnonymousAccessible);
        return this;
    }

    public Boolean isSupportOrdering() {
        return ((QueueDescription)this.getModel()).isSupportOrdering();
    }

    public QueueInfo setSupportOrdering(Boolean supportOrdering) {
        ((QueueDescription)this.getModel()).setSupportOrdering(supportOrdering);
        return this;
    }

    public EntityStatus getStatus() {
        return ((QueueDescription)this.getModel()).getStatus();
    }

    public QueueInfo setStatus(EntityStatus entityStatus) {
        ((QueueDescription)this.getModel()).setStatus(entityStatus);
        return this;
    }

    public EntityAvailabilityStatus getEntityAvailabilityStatus() {
        return ((QueueDescription)this.getModel()).getEntityAvailabilityStatus();
    }

    public QueueInfo setEntityAvailabilityStatus(EntityAvailabilityStatus entityAvailabilityStatus) {
        ((QueueDescription)this.getModel()).setEntityAvailabilityStatus(entityAvailabilityStatus);
        return this;
    }

    public Calendar getCreatedAt() {
        return ((QueueDescription)this.getModel()).getCreatedAt();
    }

    public QueueInfo setCreatedAt(Calendar createdAt) {
        ((QueueDescription)this.getModel()).setCreatedAt(createdAt);
        return this;
    }

    public Calendar getUpdatedAt() {
        return ((QueueDescription)this.getModel()).getUpdatedAt();
    }

    public QueueInfo setUpdatedAt(Calendar updatedAt) {
        ((QueueDescription)this.getModel()).setUpdatedAt(updatedAt);
        return this;
    }

    public Calendar getAccessedAt() {
        return ((QueueDescription)this.getModel()).getAccessedAt();
    }

    public QueueInfo setAccessedAt(Calendar accessedAt) {
        ((QueueDescription)this.getModel()).setAccessedAt(accessedAt);
        return this;
    }

    public PartitioningPolicy getPartitioningPolicy() {
        return ((QueueDescription)this.getModel()).getPartitioningPolicy();
    }

    public QueueInfo setPartitioningPolicy(PartitioningPolicy partitioningPolicy) {
        ((QueueDescription)this.getModel()).setPartitioningPolicy(partitioningPolicy);
        return this;
    }

    public String getUserMetadata() {
        return ((QueueDescription)this.getModel()).getUserMetadata();
    }

    public QueueInfo setUserMetadata(String userMetadata) {
        ((QueueDescription)this.getModel()).setUserMetadata(userMetadata);
        return this;
    }

    public MessageCountDetails getCountDetails() {
        return ((QueueDescription)this.getModel()).getCountDetails();
    }

    public QueueInfo setUri(URI uri) {
        this.getEntry().setId(uri.toString());
        return this;
    }

    public URI getUri() {
        return URI.create(this.removeQueryString(this.getEntry().getId()));
    }

    private String removeQueryString(String uri) {
        String[] result = uri.split("\\?");
        return result[0];
    }

    public QueueInfo setForwardTo(String forwardTo) {
        ((QueueDescription)this.getModel()).setForwardTo(forwardTo);
        return this;
    }

    public String getForwardTo() {
        return ((QueueDescription)this.getModel()).getForwardTo();
    }
}

