/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.serviceBus.implementation;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.serviceBus.implementation.WrapTokenManager;
import com.sun.jersey.api.client.ClientHandlerException;
import com.sun.jersey.api.client.ClientRequest;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.net.URI;
import java.net.URISyntaxException;

public class WrapFilter
extends ClientFilter {
    private final WrapTokenManager tokenManager;

    public WrapFilter(WrapTokenManager tokenManager) {
        this.tokenManager = tokenManager;
    }

    public ClientResponse handle(ClientRequest cr) throws ClientHandlerException {
        String accessToken = this.getWrapToken(cr.getURI());
        cr.getHeaders().add((Object)"Authorization", (Object)accessToken);
        String secondaryAuthorizationUri = (String)cr.getHeaders().getFirst((Object)"ServiceBusSupplementaryAuthorization");
        if (secondaryAuthorizationUri != null && !secondaryAuthorizationUri.isEmpty()) {
            String secondaryAccessToken = this.getWrapToken(URI.create(secondaryAuthorizationUri));
            cr.getHeaders().remove((Object)"ServiceBusSupplementaryAuthorization");
            cr.getHeaders().add((Object)"ServiceBusSupplementaryAuthorization", (Object)secondaryAccessToken);
        }
        return this.getNext().handle(cr);
    }

    private String getWrapToken(URI uri) {
        String result;
        try {
            result = this.tokenManager.getAccessToken(uri);
        }
        catch (ServiceException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        catch (URISyntaxException e) {
            throw new ClientHandlerException((Throwable)e);
        }
        return "WRAP access_token=\"" + result + "\"";
    }
}

