/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.serviceBus.implementation;

import com.microsoft.windowsazure.services.core.utils.ConnectionStringSyntaxException;
import com.microsoft.windowsazure.services.serviceBus.implementation.ServiceBusConnectionString;
import java.net.URI;
import java.net.URISyntaxException;

class ServiceBusConnectionSettings {
    private String uri;
    private String wrapUri;
    private String wrapName;
    private String wrapPassword;

    public ServiceBusConnectionSettings(String connectionString, String uri, String wrapUri, String wrapName, String wrapPassword) throws ConnectionStringSyntaxException, URISyntaxException {
        if (connectionString != null) {
            this.parseConnectionString(connectionString);
        } else {
            this.uri = uri;
            this.wrapUri = wrapUri;
            this.wrapName = wrapName;
            this.wrapPassword = wrapPassword;
        }
    }

    public String getUri() {
        return this.uri;
    }

    public String getWrapUri() {
        return this.wrapUri;
    }

    public String getWrapName() {
        return this.wrapName;
    }

    public String getWrapPassword() {
        return this.wrapPassword;
    }

    private boolean parseConnectionString(String connectionString) throws URISyntaxException, ConnectionStringSyntaxException {
        ServiceBusConnectionString cs = new ServiceBusConnectionString(connectionString);
        this.setUri(cs);
        this.setWrapUri(cs);
        this.wrapName = cs.getSharedSecretIssuer();
        this.wrapPassword = cs.getSharedSecretValue();
        return true;
    }

    private void setUri(ServiceBusConnectionString connectionString) {
        this.uri = connectionString.getEndpoint().replaceFirst("^sb://", "https://");
    }

    private void setWrapUri(ServiceBusConnectionString connectionString) throws URISyntaxException {
        if (connectionString.getStsEndpoint() == null || connectionString.getStsEndpoint().isEmpty()) {
            URI hostUri = new URI(this.uri);
            String namespace = hostUri.getHost().split("\\.")[0];
            this.wrapUri = "https://" + namespace + "-sb.accesscontrol.windows.net/WRAPv0.9";
        } else {
            this.wrapUri = connectionString.getStsEndpoint().replaceAll("\\/$", "") + "/WRAPv0.9";
        }
    }
}

