/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.serviceBus.implementation;

import com.microsoft.windowsazure.services.core.Builder;
import com.microsoft.windowsazure.services.core.utils.ConnectionStringSyntaxException;
import com.microsoft.windowsazure.services.core.utils.ExportUtils;
import com.microsoft.windowsazure.services.serviceBus.implementation.ServiceBusConnectionSettings;
import com.microsoft.windowsazure.services.serviceBus.implementation.WrapContract;
import com.microsoft.windowsazure.services.serviceBus.implementation.WrapFilter;
import com.microsoft.windowsazure.services.serviceBus.implementation.WrapRestProxy;
import com.microsoft.windowsazure.services.serviceBus.implementation.WrapTokenManager;
import java.net.URISyntaxException;
import java.util.Map;

public class Exports
implements Builder.Exports {
    @Override
    public void register(Builder.Registry registry) {
        registry.add(WrapContract.class, WrapRestProxy.class);
        registry.add(WrapTokenManager.class);
        registry.add(WrapFilter.class);
        registry.add(new Builder.Factory<ServiceBusConnectionSettings>(){

            @Override
            public <S> ServiceBusConnectionSettings create(String profile, Class<S> service, Builder builder, Map<String, Object> properties) {
                try {
                    return new ServiceBusConnectionSettings((String)ExportUtils.getPropertyIfExists(profile, properties, "serviceBus.connection.string"), (String)ExportUtils.getPropertyIfExists(profile, properties, "serviceBus.uri"), (String)ExportUtils.getPropertyIfExists(profile, properties, "serviceBus.wrap.uri"), (String)ExportUtils.getPropertyIfExists(profile, properties, "serviceBus.wrap.name"), (String)ExportUtils.getPropertyIfExists(profile, properties, "serviceBus.wrap.password"));
                }
                catch (ConnectionStringSyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
                catch (URISyntaxException e) {
                    throw new RuntimeException(e.getMessage(), e);
                }
            }
        });
    }
}

