/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.serviceBus;

import com.microsoft.windowsazure.services.core.Configuration;

public class ServiceBusConfiguration {
    public static final String CONNECTION_STRING = "serviceBus.connection.string";
    public static final String URI = "serviceBus.uri";
    public static final String WRAP_URI = "serviceBus.wrap.uri";
    public static final String WRAP_NAME = "serviceBus.wrap.name";
    public static final String WRAP_PASSWORD = "serviceBus.wrap.password";

    public static Configuration configureWithWrapAuthentication(String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        return ServiceBusConfiguration.configureWithWrapAuthentication(null, Configuration.getInstance(), namespace, authenticationName, authenticationPassword, serviceBusRootUri, wrapRootUri);
    }

    public static Configuration configureWithWrapAuthentication(Configuration configuration, String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        return ServiceBusConfiguration.configureWithWrapAuthentication(null, configuration, namespace, authenticationName, authenticationPassword, serviceBusRootUri, wrapRootUri);
    }

    public static Configuration configureWithWrapAuthentication(String profile, Configuration configuration, String namespace, String authenticationName, String authenticationPassword, String serviceBusRootUri, String wrapRootUri) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + CONNECTION_STRING, null);
        configuration.setProperty(profile + URI, "https://" + namespace + serviceBusRootUri);
        configuration.setProperty(profile + WRAP_URI, "https://" + namespace + wrapRootUri);
        configuration.setProperty(profile + WRAP_NAME, authenticationName);
        configuration.setProperty(profile + WRAP_PASSWORD, authenticationPassword);
        return configuration;
    }

    public static Configuration configureWithConnectionString(String profile, Configuration configuration, String connectionString) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + CONNECTION_STRING, connectionString);
        return configuration;
    }
}

