/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.queue.implementation;

import com.microsoft.windowsazure.services.core.RFC1123DateConverter;
import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.core.UserAgentFilter;
import com.microsoft.windowsazure.services.core.utils.pipeline.ClientFilterAdapter;
import com.microsoft.windowsazure.services.core.utils.pipeline.HttpURLConnectionClient;
import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.services.queue.QueueContract;
import com.microsoft.windowsazure.services.queue.implementation.QueueMessage;
import com.microsoft.windowsazure.services.queue.implementation.SharedKeyFilter;
import com.microsoft.windowsazure.services.queue.models.CreateMessageOptions;
import com.microsoft.windowsazure.services.queue.models.CreateQueueOptions;
import com.microsoft.windowsazure.services.queue.models.GetQueueMetadataResult;
import com.microsoft.windowsazure.services.queue.models.GetServicePropertiesResult;
import com.microsoft.windowsazure.services.queue.models.ListMessagesOptions;
import com.microsoft.windowsazure.services.queue.models.ListMessagesResult;
import com.microsoft.windowsazure.services.queue.models.ListQueuesOptions;
import com.microsoft.windowsazure.services.queue.models.ListQueuesResult;
import com.microsoft.windowsazure.services.queue.models.PeekMessagesOptions;
import com.microsoft.windowsazure.services.queue.models.PeekMessagesResult;
import com.microsoft.windowsazure.services.queue.models.QueueServiceOptions;
import com.microsoft.windowsazure.services.queue.models.ServiceProperties;
import com.microsoft.windowsazure.services.queue.models.UpdateMessageResult;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.filter.ClientFilter;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;

public class QueueRestProxy
implements QueueContract {
    private static final String API_VERSION = "2011-08-18";
    private final HttpURLConnectionClient channel;
    private final String accountName;
    private final String url;
    private final RFC1123DateConverter dateMapper;
    private final ServiceFilter[] filters;
    private final SharedKeyFilter sharedKeyFilter;

    @Inject
    public QueueRestProxy(HttpURLConnectionClient channel, @Named(value="queue.accountName") String accountName, @Named(value="queue.uri") String url, SharedKeyFilter sharedKeyFilter, UserAgentFilter userAgentFilter) {
        this.channel = channel;
        this.accountName = accountName;
        this.url = url;
        this.sharedKeyFilter = sharedKeyFilter;
        this.dateMapper = new RFC1123DateConverter();
        this.filters = new ServiceFilter[0];
        channel.addFilter(sharedKeyFilter);
        channel.addFilter(userAgentFilter);
    }

    public QueueRestProxy(HttpURLConnectionClient channel, ServiceFilter[] filters, String accountName, String url, SharedKeyFilter filter, RFC1123DateConverter dateMapper) {
        this.channel = channel;
        this.filters = filters;
        this.accountName = accountName;
        this.url = url;
        this.sharedKeyFilter = filter;
        this.dateMapper = dateMapper;
    }

    @Override
    public QueueContract withFilter(ServiceFilter filter) {
        ServiceFilter[] newFilters = Arrays.copyOf(this.filters, this.filters.length + 1);
        newFilters[this.filters.length] = filter;
        return new QueueRestProxy(this.channel, newFilters, this.accountName, this.url, this.sharedKeyFilter, this.dateMapper);
    }

    private void ThrowIfError(ClientResponse r) {
        PipelineHelpers.ThrowIfError(r);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, Object value) {
        return PipelineHelpers.addOptionalQueryParam(webResource, key, value);
    }

    private WebResource addOptionalQueryParam(WebResource webResource, String key, int value, int defaultValue) {
        return PipelineHelpers.addOptionalQueryParam(webResource, key, value, defaultValue);
    }

    private WebResource.Builder addOptionalMetadataHeader(WebResource.Builder builder, Map<String, String> metadata) {
        return PipelineHelpers.addOptionalMetadataHeader(builder, metadata);
    }

    private HashMap<String, String> getMetadataFromHeaders(ClientResponse response) {
        return PipelineHelpers.getMetadataFromHeaders(response);
    }

    private WebResource getResource(QueueServiceOptions options) {
        WebResource webResource = this.channel.resource(this.url).path("/");
        webResource = this.addOptionalQueryParam(webResource, "timeout", options.getTimeout());
        for (ServiceFilter filter : this.filters) {
            webResource.addFilter((ClientFilter)new ClientFilterAdapter(filter));
        }
        return webResource;
    }

    @Override
    public GetServicePropertiesResult getServiceProperties() throws ServiceException {
        return this.getServiceProperties(new QueueServiceOptions());
    }

    @Override
    public GetServicePropertiesResult getServiceProperties(QueueServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        GetServicePropertiesResult result = new GetServicePropertiesResult();
        result.setValue((ServiceProperties)builder.get(ServiceProperties.class));
        return result;
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties) throws ServiceException {
        this.setServiceProperties(serviceProperties, new QueueServiceOptions());
    }

    @Override
    public void setServiceProperties(ServiceProperties serviceProperties, QueueServiceOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("resType", "service").queryParam("comp", "properties");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.put((Object)serviceProperties);
    }

    @Override
    public void createQueue(String queue) throws ServiceException {
        this.createQueue(queue, new CreateQueueOptions());
    }

    @Override
    public void createQueue(String queue, CreateQueueOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalMetadataHeader(builder, options.getMetadata());
        builder.put();
    }

    @Override
    public void deleteQueue(String queue) throws ServiceException {
        this.deleteQueue(queue, new QueueServiceOptions());
    }

    @Override
    public void deleteQueue(String queue, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.delete();
    }

    @Override
    public ListQueuesResult listQueues() throws ServiceException {
        return this.listQueues(new ListQueuesOptions());
    }

    @Override
    public ListQueuesResult listQueues(ListQueuesOptions options) throws ServiceException {
        WebResource webResource = this.getResource(options).path("/").queryParam("comp", "list");
        webResource = this.addOptionalQueryParam(webResource, "prefix", options.getPrefix());
        webResource = this.addOptionalQueryParam(webResource, "marker", options.getMarker());
        webResource = this.addOptionalQueryParam(webResource, "maxresults", options.getMaxResults(), 0);
        if (options.isIncludeMetadata()) {
            webResource = webResource.queryParam("include", "metadata");
        }
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (ListQueuesResult)builder.get(ListQueuesResult.class);
    }

    @Override
    public GetQueueMetadataResult getQueueMetadata(String queue) throws ServiceException {
        return this.getQueueMetadata(queue, new QueueServiceOptions());
    }

    @Override
    public GetQueueMetadataResult getQueueMetadata(String queue, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).queryParam("comp", "metadata");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        this.ThrowIfError(response);
        GetQueueMetadataResult result = new GetQueueMetadataResult();
        result.setApproximateMessageCount(Integer.parseInt((String)response.getHeaders().getFirst((Object)"x-ms-approximate-messages-count")));
        result.setMetadata(this.getMetadataFromHeaders(response));
        return result;
    }

    @Override
    public void setQueueMetadata(String queue, HashMap<String, String> metadata) throws ServiceException {
        this.setQueueMetadata(queue, metadata, new QueueServiceOptions());
    }

    @Override
    public void setQueueMetadata(String queue, HashMap<String, String> metadata, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).queryParam("comp", "metadata");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder = this.addOptionalMetadataHeader(builder, metadata);
        builder.put();
    }

    @Override
    public void createMessage(String queue, String messageText) throws ServiceException {
        this.createMessage(queue, messageText, new CreateMessageOptions());
    }

    @Override
    public void createMessage(String queue, String messageText, CreateMessageOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (messageText == null) {
            throw new NullPointerException("messageText");
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages");
        webResource = this.addOptionalQueryParam(webResource, "visibilitytimeout", options.getVisibilityTimeoutInSeconds());
        webResource = this.addOptionalQueryParam(webResource, "messagettl", options.getTimeToLiveInSeconds());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setMessageText(messageText);
        builder.post((Object)queueMessage);
    }

    @Override
    public UpdateMessageResult updateMessage(String queue, String messageId, String popReceipt, String messageText, int visibilityTimeoutInSeconds) throws ServiceException {
        return this.updateMessage(queue, messageId, popReceipt, messageText, visibilityTimeoutInSeconds, new QueueServiceOptions());
    }

    @Override
    public UpdateMessageResult updateMessage(String queue, String messageId, String popReceipt, String messageText, int visibilityTimeoutInSeconds, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException("queue");
        }
        if (messageId == null) {
            throw new NullPointerException("messageId");
        }
        if (messageText == null) {
            throw new NullPointerException("messageText");
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages").path(messageId);
        webResource = this.addOptionalQueryParam(webResource, "popreceipt", popReceipt);
        webResource = this.addOptionalQueryParam(webResource, "visibilitytimeout", visibilityTimeoutInSeconds);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        QueueMessage queueMessage = new QueueMessage();
        queueMessage.setMessageText(messageText);
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class, (Object)queueMessage);
        this.ThrowIfError(response);
        UpdateMessageResult result = new UpdateMessageResult();
        result.setPopReceipt((String)response.getHeaders().getFirst((Object)"x-ms-popreceipt"));
        result.setTimeNextVisible(this.dateMapper.parse((String)response.getHeaders().getFirst((Object)"x-ms-time-next-visible")));
        return result;
    }

    @Override
    public ListMessagesResult listMessages(String queue) throws ServiceException {
        return this.listMessages(queue, new ListMessagesOptions());
    }

    @Override
    public ListMessagesResult listMessages(String queue, ListMessagesOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages");
        webResource = this.addOptionalQueryParam(webResource, "visibilitytimeout", options.getVisibilityTimeoutInSeconds());
        webResource = this.addOptionalQueryParam(webResource, "numofmessages", options.getNumberOfMessages());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (ListMessagesResult)builder.get(ListMessagesResult.class);
    }

    @Override
    public PeekMessagesResult peekMessages(String queue) throws ServiceException {
        return this.peekMessages(queue, new PeekMessagesOptions());
    }

    @Override
    public PeekMessagesResult peekMessages(String queue, PeekMessagesOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages").queryParam("peekonly", "true");
        webResource = this.addOptionalQueryParam(webResource, "numofmessages", options.getNumberOfMessages());
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        return (PeekMessagesResult)builder.get(PeekMessagesResult.class);
    }

    @Override
    public void deleteMessage(String queue, String messageId, String popReceipt) throws ServiceException {
        this.deleteMessage(queue, messageId, popReceipt, new QueueServiceOptions());
    }

    @Override
    public void deleteMessage(String queue, String messageId, String popReceipt, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        if (messageId == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages").path(messageId);
        webResource = this.addOptionalQueryParam(webResource, "popreceipt", popReceipt);
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.delete();
    }

    @Override
    public void clearMessages(String queue) throws ServiceException {
        this.clearMessages(queue, new QueueServiceOptions());
    }

    @Override
    public void clearMessages(String queue, QueueServiceOptions options) throws ServiceException {
        if (queue == null) {
            throw new NullPointerException();
        }
        WebResource webResource = this.getResource(options).path(queue).path("messages");
        WebResource.Builder builder = webResource.header("x-ms-version", (Object)API_VERSION);
        builder.delete();
    }
}

