/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityBatchOperation;
import com.microsoft.windowsazure.services.media.implementation.content.TaskType;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.TaskInfo;
import com.microsoft.windowsazure.services.media.models.TaskOption;
import com.sun.jersey.api.client.GenericType;

public class Task {
    private static final String ENTITY_SET = "Tasks";

    private Task() {
    }

    public static CreateBatchOperation create(String mediaProcessorId, String taskBody) {
        return new CreateBatchOperation(mediaProcessorId, taskBody);
    }

    public static DefaultListOperation<TaskInfo> list() {
        return new DefaultListOperation<TaskInfo>(ENTITY_SET, new GenericType<ListResult<TaskInfo>>(){});
    }

    public static DefaultListOperation<TaskInfo> list(LinkInfo<TaskInfo> link) {
        return new DefaultListOperation<TaskInfo>(link.getHref(), new GenericType<ListResult<TaskInfo>>(){});
    }

    public static class CreateBatchOperation
    extends EntityBatchOperation {
        private final TaskType taskType;

        public CreateBatchOperation(String mediaProcessorId, String taskBody) {
            this.verb = "POST";
            this.taskType = new TaskType();
            this.addContentObject(this.taskType);
            this.taskType.setMediaProcessorId(mediaProcessorId);
            this.taskType.setTaskBody(taskBody);
        }

        public CreateBatchOperation setOptions(TaskOption options) {
            this.taskType.setOptions(options.getCode());
            return this;
        }

        public CreateBatchOperation setConfiguration(String configuration) {
            this.taskType.setConfiguration(configuration);
            return this;
        }

        public CreateBatchOperation setName(String name) {
            this.taskType.setName(name);
            return this;
        }

        public CreateBatchOperation setTaskBody(String taskBody) {
            this.taskType.setTaskBody(taskBody);
            return this;
        }

        public CreateBatchOperation setMediaProcessorId(String mediaProcessorId) {
            this.taskType.setMediaProcessorId(mediaProcessorId);
            return this;
        }

        public CreateBatchOperation setPriority(int priority) {
            this.taskType.setPriority(priority);
            return this;
        }

        public CreateBatchOperation setEncryptionKeyId(String encryptionKeyId) {
            this.taskType.setEncryptionKeyId(encryptionKeyId);
            return this;
        }

        public CreateBatchOperation setEncryptionScheme(String encryptionScheme) {
            this.taskType.setEncryptionScheme(encryptionScheme);
            return this;
        }

        public CreateBatchOperation setEncryptionVersion(String encryptionVersion) {
            this.taskType.setEncryptionVersion(encryptionVersion);
            return this;
        }

        public CreateBatchOperation setInitializationVector(String initializationVector) {
            this.taskType.setInitializationVector(initializationVector);
            return this;
        }
    }
}

