/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultEntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.implementation.content.ProtectionKeyIdType;
import com.microsoft.windowsazure.services.media.implementation.content.ProtectionKeyRestType;
import com.microsoft.windowsazure.services.media.models.ContentKeyType;
import com.sun.jersey.api.client.ClientResponse;
import java.io.InputStream;
import javax.ws.rs.core.MediaType;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ProtectionKey {
    private ProtectionKey() {
    }

    public static EntityTypeActionOperation<String> getProtectionKeyId(ContentKeyType contentKeyType) {
        return ((DefaultEntityTypeActionOperation)new GetProtectionKeyIdActionOperation("GetProtectionKeyId").addQueryParameter("contentKeyType", String.format("%d", contentKeyType.getCode()))).setAcceptType(MediaType.APPLICATION_XML_TYPE);
    }

    public static EntityTypeActionOperation<String> getProtectionKey(String protectionKeyId) {
        return ((DefaultEntityTypeActionOperation)new GetProtectionKeyActionOperation("GetProtectionKey").addQueryParameter("ProtectionKeyId", String.format("'%s'", protectionKeyId))).setAcceptType(MediaType.APPLICATION_XML_TYPE);
    }

    private static class GetProtectionKeyActionOperation
    extends DefaultEntityTypeActionOperation<String> {
        private final JAXBContext jaxbContext;
        private final Unmarshaller unmarshaller;

        public GetProtectionKeyActionOperation(String name) {
            super(name);
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProtectionKeyRestType.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            try {
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String processTypeResponse(ClientResponse clientResponse) {
            ProtectionKeyRestType protectionKeyRestType;
            PipelineHelpers.ThrowIfNotSuccess(clientResponse);
            try {
                protectionKeyRestType = this.parseResponse(clientResponse);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            return protectionKeyRestType.getProtectionKey();
        }

        private ProtectionKeyRestType parseResponse(ClientResponse clientResponse) throws JAXBException {
            InputStream inputStream = clientResponse.getEntityInputStream();
            JAXBElement protectionKeyTypeJaxbElement = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), ProtectionKeyRestType.class);
            return (ProtectionKeyRestType)protectionKeyTypeJaxbElement.getValue();
        }
    }

    private static class GetProtectionKeyIdActionOperation
    extends DefaultEntityTypeActionOperation<String> {
        private final JAXBContext jaxbContext;
        private final Unmarshaller unmarshaller;

        public GetProtectionKeyIdActionOperation(String name) {
            super(name);
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{ProtectionKeyIdType.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            try {
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String processTypeResponse(ClientResponse clientResponse) {
            ProtectionKeyIdType protectionKeyIdType;
            PipelineHelpers.ThrowIfNotSuccess(clientResponse);
            try {
                protectionKeyIdType = this.parseResponse(clientResponse);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            return protectionKeyIdType.getProtectionKeyId();
        }

        private ProtectionKeyIdType parseResponse(ClientResponse clientResponse) throws JAXBException {
            InputStream inputStream = clientResponse.getEntityInputStream();
            JAXBElement protectionKeyIdTypeJaxbElement = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), ProtectionKeyIdType.class);
            return (ProtectionKeyIdType)protectionKeyIdTypeJaxbElement.getValue();
        }
    }
}

