/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import com.microsoft.windowsazure.services.core.utils.pipeline.PipelineHelpers;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultEntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.DefaultListOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityCreateOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityDeleteOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityGetOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperationSingleResultBase;
import com.microsoft.windowsazure.services.media.entityoperations.EntityTypeActionOperation;
import com.microsoft.windowsazure.services.media.implementation.content.ContentKeyRestType;
import com.microsoft.windowsazure.services.media.implementation.content.RebindContentKeyType;
import com.microsoft.windowsazure.services.media.models.ContentKeyInfo;
import com.microsoft.windowsazure.services.media.models.ContentKeyType;
import com.microsoft.windowsazure.services.media.models.LinkInfo;
import com.microsoft.windowsazure.services.media.models.ListResult;
import com.microsoft.windowsazure.services.media.models.ProtectionKeyType;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.GenericType;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;

public class ContentKey {
    private static final String ENTITY_SET = "ContentKeys";

    private ContentKey() {
    }

    public static Creator create(String id, ContentKeyType contentKeyType, String encryptedContentKey) {
        return new Creator(id, contentKeyType, encryptedContentKey);
    }

    public static EntityGetOperation<ContentKeyInfo> get(String contentKeyId) {
        return new DefaultGetOperation<ContentKeyInfo>(ENTITY_SET, contentKeyId, ContentKeyInfo.class);
    }

    public static DefaultListOperation<ContentKeyInfo> list() {
        return new DefaultListOperation<ContentKeyInfo>(ENTITY_SET, new GenericType<ListResult<ContentKeyInfo>>(){});
    }

    public static DefaultListOperation<ContentKeyInfo> list(LinkInfo<ContentKeyInfo> link) {
        return new DefaultListOperation<ContentKeyInfo>(link.getHref(), new GenericType<ListResult<ContentKeyInfo>>(){});
    }

    public static EntityDeleteOperation delete(String contentKeyId) {
        return new DefaultDeleteOperation(ENTITY_SET, contentKeyId);
    }

    public static EntityTypeActionOperation<String> rebind(String contentKeyId, String x509Certificate) {
        return new RebindContentKeyActionOperation(contentKeyId, x509Certificate);
    }

    public static EntityTypeActionOperation<String> rebind(String contentKeyId) {
        return ContentKey.rebind(contentKeyId, "");
    }

    private static class RebindContentKeyActionOperation
    extends DefaultEntityTypeActionOperation<String> {
        private final JAXBContext jaxbContext;
        private final Unmarshaller unmarshaller;

        public RebindContentKeyActionOperation(String contentKeyId, String x509Certificate) {
            super("RebindContentKey");
            String escapedContentKeyId;
            try {
                escapedContentKeyId = URLEncoder.encode(contentKeyId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidParameterException("UTF-8 encoding is not supported.");
            }
            this.addQueryParameter("x509Certificate", "'" + x509Certificate + "'");
            this.addQueryParameter("id", "'" + escapedContentKeyId + "'");
            try {
                this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{RebindContentKeyType.class});
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            try {
                this.unmarshaller = this.jaxbContext.createUnmarshaller();
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public String processTypeResponse(ClientResponse clientResponse) {
            PipelineHelpers.ThrowIfNotSuccess(clientResponse);
            RebindContentKeyType rebindContentKeyType = this.parseResponse(clientResponse);
            return rebindContentKeyType.getContentKey();
        }

        private RebindContentKeyType parseResponse(ClientResponse clientResponse) {
            JAXBElement rebindContentKeyTypeJaxbElement;
            InputStream inputStream = clientResponse.getEntityInputStream();
            try {
                rebindContentKeyTypeJaxbElement = this.unmarshaller.unmarshal((Source)new StreamSource(inputStream), RebindContentKeyType.class);
            }
            catch (JAXBException e) {
                throw new RuntimeException(e);
            }
            return (RebindContentKeyType)rebindContentKeyTypeJaxbElement.getValue();
        }
    }

    public static class Creator
    extends EntityOperationSingleResultBase<ContentKeyInfo>
    implements EntityCreateOperation<ContentKeyInfo> {
        private final String id;
        private final ContentKeyType contentKeyType;
        private final String encryptedContentKey;
        private String name;
        private String checksum;
        private String protectionKeyId;
        private ProtectionKeyType protectionKeyType;

        public Creator(String id, ContentKeyType contentKeyType, String encryptedContentKey) {
            super(ContentKey.ENTITY_SET, ContentKeyInfo.class);
            this.id = id;
            this.contentKeyType = contentKeyType;
            this.encryptedContentKey = encryptedContentKey;
        }

        @Override
        public Object getRequestContents() {
            ContentKeyRestType contentKeyRestType = new ContentKeyRestType();
            contentKeyRestType.setId(this.id);
            if (this.contentKeyType != null) {
                contentKeyRestType.setContentKeyType(this.contentKeyType.getCode());
            }
            if (this.protectionKeyType != null) {
                contentKeyRestType.setProtectionKeyType(this.protectionKeyType.getCode());
            }
            contentKeyRestType.setEncryptedContentKey(this.encryptedContentKey);
            contentKeyRestType.setName(this.name);
            contentKeyRestType.setChecksum(this.checksum);
            contentKeyRestType.setProtectionKeyId(this.protectionKeyId);
            return contentKeyRestType;
        }

        public Creator setName(String name) {
            this.name = name;
            return this;
        }

        public Creator setChecksum(String checksum) {
            this.checksum = checksum;
            return this;
        }

        public Creator setProtectionKeyId(String protectionKeyId) {
            this.protectionKeyId = protectionKeyId;
            return this;
        }

        public Creator setProtectionKeyType(ProtectionKeyType protectionKeyType) {
            this.protectionKeyType = protectionKeyType;
            return this;
        }
    }
}

