/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.models;

import java.util.EnumSet;

public enum AccessPolicyPermission {
    NONE(0),
    READ(1),
    WRITE(2),
    DELETE(4),
    LIST(8);

    private int flagValue;

    private AccessPolicyPermission(int value) {
        this.flagValue = value;
    }

    public int getFlagValue() {
        return this.flagValue;
    }

    public static EnumSet<AccessPolicyPermission> permissionsFromBits(int bits) {
        EnumSet<AccessPolicyPermission> perms = EnumSet.of(NONE);
        for (AccessPolicyPermission p : AccessPolicyPermission.values()) {
            if ((bits & p.getFlagValue()) == 0) continue;
            perms.remove((Object)NONE);
            perms.add(p);
        }
        return perms;
    }

    public static int bitsFromPermissions(EnumSet<AccessPolicyPermission> perms) {
        int result = 0;
        for (AccessPolicyPermission p : perms) {
            result |= p.getFlagValue();
        }
        return result;
    }
}

