/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.media.implementation.ODataEntity;
import com.microsoft.windowsazure.services.media.implementation.atom.ContentType;
import com.microsoft.windowsazure.services.media.implementation.atom.EntryType;
import com.microsoft.windowsazure.services.media.implementation.atom.FeedType;
import com.microsoft.windowsazure.services.media.implementation.content.AssetType;
import com.microsoft.windowsazure.services.media.implementation.content.Constants;
import com.microsoft.windowsazure.services.media.implementation.content.ODataActionType;
import com.microsoft.windowsazure.services.media.models.ListResult;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.ParameterizedType;
import java.util.ArrayList;
import java.util.List;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.namespace.QName;
import javax.xml.transform.Source;
import javax.xml.transform.stream.StreamSource;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ODataAtomUnmarshaller {
    private final JAXBContext atomContext = JAXBContext.newInstance((String)FeedType.class.getPackage().getName());
    private final JAXBContext mediaContentContext;
    private final Unmarshaller atomUnmarshaller = this.atomContext.createUnmarshaller();
    private final Unmarshaller mediaContentUnmarshaller;

    public ODataAtomUnmarshaller() throws JAXBException {
        this.mediaContentContext = JAXBContext.newInstance((String)AssetType.class.getPackage().getName());
        this.mediaContentUnmarshaller = this.mediaContentContext.createUnmarshaller();
    }

    public <T extends ODataEntity> ListResult<T> unmarshalFeed(InputStream stream, Class<T> contentType) throws JAXBException, ServiceException {
        ODataAtomUnmarshaller.validateNotNull(stream, "stream");
        ODataAtomUnmarshaller.validateNotNull(contentType, "contentType");
        ArrayList<T> entries = new ArrayList<T>();
        FeedType feed = this.unmarshalFeed(stream);
        Class<?> marshallingContentType = ODataAtomUnmarshaller.getMarshallingContentType(contentType);
        for (Object feedChild : feed.getFeedChildren()) {
            EntryType entry = this.asEntry(feedChild);
            if (entry == null) continue;
            entries.add(this.contentFromEntry(contentType, marshallingContentType, entry));
        }
        return new ListResult(entries);
    }

    public <T extends ODataEntity> T unmarshalEntry(InputStream stream, Class<T> contentType) throws JAXBException, ServiceException {
        ODataAtomUnmarshaller.validateNotNull(stream, "stream");
        ODataAtomUnmarshaller.validateNotNull(contentType, "contentType");
        Class<?> marshallingContentType = ODataAtomUnmarshaller.getMarshallingContentType(contentType);
        EntryType entry = this.unmarshalEntry(stream);
        return this.contentFromEntry(contentType, marshallingContentType, entry);
    }

    private <T extends ODataEntity> T contentFromEntry(Class<T> contentType, Class<?> marshallingContentType, EntryType entry) throws JAXBException, ServiceException {
        this.unmarshalODataContent(entry, contentType);
        ContentType contentElement = this.getFirstOfType(ContentType.class, entry.getEntryChildren());
        Object contentObject = this.getFirstOfType(marshallingContentType, contentElement.getContent());
        return this.constructResultObject(contentType, entry, contentObject);
    }

    private EntryType asEntry(Object o) {
        JAXBElement e;
        if (o instanceof JAXBElement && (e = (JAXBElement)o).getDeclaredType() == EntryType.class) {
            return (EntryType)e.getValue();
        }
        return null;
    }

    private void unmarshalODataContent(EntryType entry, Class<?> contentType) throws JAXBException {
        this.unmarshalEntryActions(entry);
        this.unmarshalEntryContent(entry, contentType);
    }

    private void unmarshalEntryActions(EntryType entry) throws JAXBException {
        List<Object> children = entry.getEntryChildren();
        for (int i = 0; i < children.size(); ++i) {
            Element e;
            Object child = children.get(i);
            if (!(child instanceof Element) || !ODataAtomUnmarshaller.qnameFromElement(e = (Element)child).equals(Constants.ODATA_ACTION_ELEMENT_NAME)) continue;
            JAXBElement actionElement = this.mediaContentUnmarshaller.unmarshal((Node)e, ODataActionType.class);
            children.set(i, actionElement);
        }
    }

    private void unmarshalEntryContent(EntryType entry, Class<?> contentType) throws JAXBException {
        Class<?> marshallingContentType = ODataAtomUnmarshaller.getMarshallingContentType(contentType);
        ContentType contentElement = this.getFirstOfType(ContentType.class, entry.getEntryChildren());
        List<Object> contentChildren = contentElement.getContent();
        for (int i = 0; i < contentChildren.size(); ++i) {
            Element e;
            Object child = contentChildren.get(i);
            if (!(child instanceof Element) || !ODataAtomUnmarshaller.qnameFromElement(e = (Element)child).equals(Constants.ODATA_PROPERTIES_ELEMENT_NAME)) continue;
            JAXBElement actualContentElement = this.mediaContentUnmarshaller.unmarshal((Node)e, marshallingContentType);
            contentChildren.set(i, actualContentElement);
        }
    }

    private <T> T getFirstOfType(Class<T> targetType, List<Object> collection) {
        for (Object c : collection) {
            JAXBElement e;
            if (!(c instanceof JAXBElement) || (e = (JAXBElement)c).getDeclaredType() != targetType) continue;
            return (T)e.getValue();
        }
        return null;
    }

    private <T extends ODataEntity> T constructResultObject(Class<T> contentType, EntryType entry, Object contentObject) throws ServiceException {
        Class<?> marshallingType = ODataAtomUnmarshaller.getMarshallingContentType(contentType);
        try {
            Constructor<T> resultCtor = contentType.getConstructor(EntryType.class, marshallingType);
            return (T)((ODataEntity)resultCtor.newInstance(entry, contentObject));
        }
        catch (IllegalArgumentException e) {
            throw new ServiceException(e);
        }
        catch (SecurityException e) {
            throw new ServiceException(e);
        }
        catch (InstantiationException e) {
            throw new ServiceException(e);
        }
        catch (IllegalAccessException e) {
            throw new ServiceException(e);
        }
        catch (InvocationTargetException e) {
            throw new ServiceException(e);
        }
        catch (NoSuchMethodException e) {
            throw new ServiceException(e);
        }
    }

    public EntryType unmarshalEntry(InputStream stream) throws JAXBException {
        JAXBElement entryElement = this.atomUnmarshaller.unmarshal((Source)new StreamSource(stream), EntryType.class);
        return (EntryType)entryElement.getValue();
    }

    private FeedType unmarshalFeed(InputStream stream) throws JAXBException {
        JAXBElement feedElement = this.atomUnmarshaller.unmarshal((Source)new StreamSource(stream), FeedType.class);
        return (FeedType)feedElement.getValue();
    }

    private static QName qnameFromElement(Element e) {
        return new QName(e.getLocalName(), e.getNamespaceURI());
    }

    private static Class<?> getMarshallingContentType(Class<?> contentType) {
        ParameterizedType pt = (ParameterizedType)contentType.getGenericSuperclass();
        return (Class)pt.getActualTypeArguments()[0];
    }

    private static void validateNotNull(Object param, String paramName) {
        if (param == null) {
            throw new IllegalArgumentException(paramName);
        }
    }
}

