/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.utils.DateFactory;
import com.microsoft.windowsazure.services.media.implementation.ActiveToken;
import com.microsoft.windowsazure.services.media.implementation.OAuthContract;
import com.microsoft.windowsazure.services.media.implementation.OAuthTokenResponse;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.Date;
import javax.inject.Named;

public class OAuthTokenManager {
    private final DateFactory dateFactory;
    private final URI acsBaseUri;
    private final String clientId;
    private final String clientSecret;
    private final OAuthContract contract;
    private ActiveToken activeToken;
    private final String scope;

    public OAuthTokenManager(OAuthContract contract, DateFactory dateFactory, @Named(value="media.oauth.uri") String oAuthUri, @Named(value="media.oauth.client.id") String clientId, @Named(value="media.oauth.client.secret") String clientSecret, @Named(value="media.oauth.scope") String scope) throws URISyntaxException {
        this.contract = contract;
        this.dateFactory = dateFactory;
        this.acsBaseUri = new URI(oAuthUri);
        this.clientId = clientId;
        this.clientSecret = clientSecret;
        this.scope = scope;
        this.activeToken = null;
    }

    public String getAccessToken() throws ServiceException, URISyntaxException {
        Date now = this.dateFactory.getDate();
        if (this.activeToken == null || now.after(this.activeToken.getExpiresUtc())) {
            OAuthTokenResponse oAuth2TokenResponse = this.contract.getAccessToken(this.acsBaseUri, this.clientId, this.clientSecret, this.scope);
            Date expiresUtc = new Date(now.getTime() + oAuth2TokenResponse.getExpiresIn() * 1000L / 2L);
            ActiveToken newToken = new ActiveToken();
            newToken.setAccessToken(oAuth2TokenResponse.getAccessToken());
            newToken.setExpiresUtc(expiresUtc);
            this.activeToken = newToken;
        }
        return this.activeToken.getAccessToken();
    }
}

