/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.implementation;

import com.microsoft.windowsazure.services.blob.BlobContract;
import com.microsoft.windowsazure.services.blob.implementation.BlobExceptionProcessor;
import com.microsoft.windowsazure.services.blob.models.BlockList;
import com.microsoft.windowsazure.services.blob.models.CommitBlobBlocksOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobBlockOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobOptions;
import com.microsoft.windowsazure.services.blob.models.CreateBlobResult;
import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.core.ServiceFilter;
import com.microsoft.windowsazure.services.media.WritableBlobContainerContract;
import com.microsoft.windowsazure.services.media.implementation.MediaBlobRestProxy;
import com.microsoft.windowsazure.services.media.implementation.SASTokenFilter;
import com.sun.jersey.api.client.Client;
import java.io.InputStream;

public class MediaBlobContainerWriter
implements WritableBlobContainerContract {
    private final BlobContract blobService;
    private final BlobContract restProxy;
    private final String containerName;

    public MediaBlobContainerWriter(Client client, String accountName, String blobServiceUri, String containerName, String sasToken) {
        this.containerName = containerName;
        this.restProxy = new MediaBlobRestProxy(client, accountName, blobServiceUri, new SASTokenFilter(sasToken));
        this.blobService = new BlobExceptionProcessor(this.restProxy);
    }

    private MediaBlobContainerWriter(MediaBlobContainerWriter baseWriter, ServiceFilter filter) {
        this.containerName = baseWriter.containerName;
        this.restProxy = (BlobContract)baseWriter.restProxy.withFilter(filter);
        this.blobService = new BlobExceptionProcessor(this.restProxy);
    }

    @Override
    public WritableBlobContainerContract withFilter(ServiceFilter filter) {
        return new MediaBlobContainerWriter(this, filter);
    }

    @Override
    public CreateBlobResult createBlockBlob(String blob, InputStream contentStream) throws ServiceException {
        return this.blobService.createBlockBlob(this.containerName, blob, contentStream);
    }

    @Override
    public CreateBlobResult createBlockBlob(String blob, InputStream contentStream, CreateBlobOptions options) throws ServiceException {
        return this.blobService.createBlockBlob(this.containerName, blob, contentStream, options);
    }

    @Override
    public void createBlobBlock(String blob, String blockId, InputStream contentStream) throws ServiceException {
        this.blobService.createBlobBlock(this.containerName, blob, blockId, contentStream);
    }

    @Override
    public void createBlobBlock(String blob, String blockId, InputStream contentStream, CreateBlobBlockOptions options) throws ServiceException {
        this.blobService.createBlobBlock(this.containerName, blob, blockId, contentStream, options);
    }

    @Override
    public void commitBlobBlocks(String blob, BlockList blockList) throws ServiceException {
        this.blobService.commitBlobBlocks(this.containerName, blob, blockList);
    }

    @Override
    public void commitBlobBlocks(String blob, BlockList blockList, CommitBlobBlocksOptions options) throws ServiceException {
        this.blobService.commitBlobBlocks(this.containerName, blob, blockList, options);
    }
}

