/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.services.core.ServiceException;
import com.microsoft.windowsazure.services.media.entityoperations.EntityOperation;
import com.microsoft.windowsazure.services.media.entityoperations.EntityProxyData;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import javax.ws.rs.core.MediaType;

public abstract class EntityOperationBase
implements EntityOperation {
    private final EntityUriBuilder uriBuilder;
    private EntityProxyData proxyData;

    protected EntityOperationBase(final String uri) {
        this.uriBuilder = new EntityUriBuilder(){

            @Override
            public String getUri() {
                return uri;
            }
        };
    }

    protected EntityOperationBase(EntityUriBuilder uriBuilder) {
        this.uriBuilder = uriBuilder;
    }

    @Override
    public void setProxyData(EntityProxyData proxyData) {
        this.proxyData = proxyData;
    }

    protected EntityProxyData getProxyData() {
        return this.proxyData;
    }

    @Override
    public String getUri() {
        return this.uriBuilder.getUri();
    }

    @Override
    public MediaType getContentType() {
        return MediaType.APPLICATION_ATOM_XML_TYPE;
    }

    @Override
    public MediaType getAcceptType() {
        return MediaType.APPLICATION_ATOM_XML_TYPE;
    }

    @Override
    public Object processResponse(Object rawResponse) throws ServiceException {
        return rawResponse;
    }

    public static class EntityIdUriBuilder
    implements EntityUriBuilder {
        private final String entityType;
        private final String entityId;

        public EntityIdUriBuilder(String entityName, String entityId) {
            this.entityType = entityName;
            this.entityId = entityId;
        }

        @Override
        public String getUri() {
            String escapedEntityId;
            try {
                escapedEntityId = URLEncoder.encode(this.entityId, "UTF-8");
            }
            catch (UnsupportedEncodingException e) {
                throw new InvalidParameterException(this.entityId);
            }
            return String.format("%s('%s')", this.entityType, escapedEntityId);
        }
    }

    public static interface EntityUriBuilder {
        public String getUri();
    }
}

