/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media.entityoperations;

import com.microsoft.windowsazure.services.media.entityoperations.DefaultActionOperation;
import com.microsoft.windowsazure.services.media.implementation.content.MediaUriType;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLEncoder;
import java.security.InvalidParameterException;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.namespace.QName;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EntityLinkOperation
extends DefaultActionOperation {
    private final String primaryEntitySet;
    private final String primaryEntityId;
    private final String secondaryEntitySet;
    private final URI secondaryEntityUri;
    private final JAXBContext jaxbContext;
    private final Marshaller marshaller;
    private final DocumentBuilder documentBuilder;
    private final DocumentBuilderFactory documentBuilderFactory;

    public EntityLinkOperation(String primaryEntitySet, String primaryEntityId, String secondaryEntitySet, URI secondaryEntityUri) {
        this.primaryEntitySet = primaryEntitySet;
        this.primaryEntityId = primaryEntityId;
        this.secondaryEntitySet = secondaryEntitySet;
        this.secondaryEntityUri = secondaryEntityUri;
        try {
            this.jaxbContext = JAXBContext.newInstance((Class[])new Class[]{MediaUriType.class});
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        try {
            this.marshaller = this.jaxbContext.createMarshaller();
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        this.documentBuilderFactory = DocumentBuilderFactory.newInstance();
        try {
            this.documentBuilder = this.documentBuilderFactory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getUri() {
        String escapedEntityId;
        try {
            escapedEntityId = URLEncoder.encode(this.primaryEntityId, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new InvalidParameterException("UTF-8 encoding is not supported.");
        }
        return String.format("%s('%s')/$links/%s", this.primaryEntitySet, escapedEntityId, this.secondaryEntitySet);
    }

    @Override
    public String getVerb() {
        return "POST";
    }

    @Override
    public Object getRequestContents() {
        MediaUriType mediaUriType = new MediaUriType();
        mediaUriType.setUri(this.getProxyData().getServiceUri().toString() + this.secondaryEntityUri.toString());
        JAXBElement mediaUriTypeElement = new JAXBElement(new QName("http://schemas.microsoft.com/ado/2007/08/dataservices", "uri"), MediaUriType.class, (Object)mediaUriType);
        Document document = this.documentBuilder.newDocument();
        document.setXmlStandalone(true);
        try {
            this.marshaller.marshal((Object)mediaUriTypeElement, (Node)document);
        }
        catch (JAXBException e) {
            throw new RuntimeException(e);
        }
        return document;
    }
}

