/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.media;

import com.microsoft.windowsazure.services.core.Configuration;

public class MediaConfiguration {
    public static final String URI = "media.uri";
    public static final String OAUTH_URI = "media.oauth.uri";
    public static final String OAUTH_CLIENT_ID = "media.oauth.client.id";
    public static final String OAUTH_CLIENT_SECRET = "media.oauth.client.secret";
    public static final String OAUTH_SCOPE = "media.oauth.scope";

    private MediaConfiguration() {
    }

    public static Configuration configureWithOAuthAuthentication(String mediaServiceUri, String oAuthUri, String clientId, String clientSecret, String scope) {
        return MediaConfiguration.configureWithOAuthAuthentication(null, Configuration.getInstance(), mediaServiceUri, oAuthUri, clientId, clientSecret, scope);
    }

    public static Configuration configureWithOAuthAuthentication(Configuration configuration, String mediaServiceUri, String oAuthUri, String clientId, String clientSecret, String scope) {
        return MediaConfiguration.configureWithOAuthAuthentication(null, configuration, mediaServiceUri, oAuthUri, clientId, clientSecret, scope);
    }

    public static Configuration configureWithOAuthAuthentication(String profile, Configuration configuration, String mediaServiceUri, String oAuthUri, String clientId, String clientSecret, String scope) {
        if (profile == null) {
            profile = "";
        } else if (profile.length() != 0 && !profile.endsWith(".")) {
            profile = profile + ".";
        }
        configuration.setProperty(profile + URI, mediaServiceUri);
        configuration.setProperty(profile + OAUTH_URI, oAuthUri);
        configuration.setProperty(profile + OAUTH_CLIENT_ID, clientId);
        configuration.setProperty(profile + OAUTH_CLIENT_SECRET, clientSecret);
        configuration.setProperty(profile + OAUTH_SCOPE, scope);
        return configuration;
    }
}

