/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.StorageExtendedErrorInformation;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.io.InputStream;
import java.io.Reader;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;

public final class StorageErrorResponse {
    private final StorageExtendedErrorInformation errorInfo;
    private boolean isParsed;
    private XMLStreamReader xmlr = null;
    private boolean useLowerCaseElementNames = false;

    public StorageErrorResponse(InputStream stream) throws XMLStreamException {
        this.xmlr = Utility.createXMLStreamReaderFromStream(stream);
        this.errorInfo = new StorageExtendedErrorInformation();
    }

    public StorageErrorResponse(Reader reader) throws XMLStreamException {
        this.xmlr = Utility.createXMLStreamReaderFromReader(reader);
        this.errorInfo = new StorageExtendedErrorInformation();
        this.useLowerCaseElementNames = true;
    }

    public StorageExtendedErrorInformation getExtendedErrorInformation() throws XMLStreamException {
        if (!this.isParsed) {
            this.parseResponse();
        }
        return this.errorInfo;
    }

    private void parseErrorException(XMLStreamReader xmlr) throws XMLStreamException {
        int eventType = xmlr.getEventType();
        xmlr.require(1, null, "ExceptionDetails");
        while (xmlr.hasNext()) {
            eventType = xmlr.next();
            if (eventType == 4) continue;
            String name = xmlr.getName().toString();
            if (eventType == 1 && name.equals("ExceptionMessage")) {
                String errorExceptionMessage = Utility.readElementFromXMLReader(xmlr, "ExceptionMessage");
                this.errorInfo.getAdditionalDetails().put("ExceptionMessage", new String[]{errorExceptionMessage});
                continue;
            }
            if (eventType == 1 && name.equals("StackTrace")) {
                String errorExceptionStack = Utility.readElementFromXMLReader(xmlr, "StackTrace");
                this.errorInfo.getAdditionalDetails().put("StackTrace", new String[]{errorExceptionStack});
                continue;
            }
            if (eventType != 2) continue;
            break;
        }
        xmlr.require(2, null, "ExceptionDetails");
    }

    private void parseResponse() throws XMLStreamException {
        int eventType = this.xmlr.getEventType();
        this.xmlr.require(7, null, null);
        eventType = this.xmlr.next();
        this.xmlr.require(1, null, this.useLowerCaseElementNames ? "Error".toLowerCase() : "Error");
        while (this.xmlr.hasNext()) {
            eventType = this.xmlr.next();
            if (eventType == 4) continue;
            if (eventType == 2) break;
            String name = this.xmlr.getName().getLocalPart().toString();
            String string = name = this.useLowerCaseElementNames ? name.toLowerCase() : name;
            if (eventType != 1) continue;
            if (name.equals(this.useLowerCaseElementNames ? "Code".toLowerCase() : "Code")) {
                this.errorInfo.setErrorCode(Utility.readElementFromXMLReader(this.xmlr, this.useLowerCaseElementNames ? "Code".toLowerCase() : "Code"));
                continue;
            }
            if (name.equals(this.useLowerCaseElementNames ? "Message".toLowerCase() : "Message")) {
                this.errorInfo.setErrorMessage(Utility.readElementFromXMLReader(this.xmlr, this.useLowerCaseElementNames ? "Message".toLowerCase() : "Message"));
                continue;
            }
            if (name.equals(this.useLowerCaseElementNames ? "ExceptionDetails".toLowerCase() : "ExceptionDetails")) {
                this.parseErrorException(this.xmlr);
                this.xmlr.require(2, null, this.useLowerCaseElementNames ? "ExceptionDetails".toLowerCase() : "ExceptionDetails");
                continue;
            }
            String tempParseString = Utility.readElementFromXMLReader(this.xmlr, name);
            this.errorInfo.getAdditionalDetails().put(name, new String[]{tempParseString});
            this.xmlr.require(2, null, null);
        }
    }
}

