/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestResult;
import com.microsoft.windowsazure.services.core.storage.ResponseReceivedEvent;
import com.microsoft.windowsazure.services.core.storage.RetryNoRetry;
import com.microsoft.windowsazure.services.core.storage.RetryPolicy;
import com.microsoft.windowsazure.services.core.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.services.core.storage.RetryResult;
import com.microsoft.windowsazure.services.core.storage.SendingRequestEvent;
import com.microsoft.windowsazure.services.core.storage.StorageErrorCode;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import com.microsoft.windowsazure.services.table.client.TableServiceException;
import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.net.URISyntaxException;
import java.security.InvalidKeyException;
import java.util.Date;
import java.util.concurrent.TimeoutException;
import javax.xml.stream.XMLStreamException;

public final class ExecutionEngine {
    protected static <CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> RESULT_TYPE execute(CLIENT_TYPE client, PARENT_TYPE parentObject, StorageOperation<CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> task, OperationContext opContext) throws StorageException {
        return ExecutionEngine.executeWithRetry(client, parentObject, task, RetryNoRetry.getInstance(), opContext);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static <CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> RESULT_TYPE executeWithRetry(CLIENT_TYPE client, PARENT_TYPE parentObject, StorageOperation<CLIENT_TYPE, PARENT_TYPE, RESULT_TYPE> task, RetryPolicyFactory policyFactory, OperationContext opContext) throws StorageException {
        RetryPolicy policy = policyFactory.createInstance(opContext);
        int currentRetryCount = 0;
        StorageException translatedException = null;
        long startTime = new Date().getTime();
        while (true) {
            try {
                task.initialize(opContext);
                RESULT_TYPE result = task.execute(client, parentObject, opContext);
                opContext.setClientTimeInMs(new Date().getTime() - startTime);
                if (!task.isNonExceptionedRetryableFailure()) {
                    HttpURLConnection request = task.getConnection();
                    if (task.getResult().getStatusCode() >= 200 && task.getResult().getStatusCode() < 300 && request != null) {
                        InputStream inStream = request.getInputStream();
                        try {
                            Utility.writeToOutputStream(inStream, null, -1L, false, false, task.getResult(), null);
                        }
                        catch (IOException ex) {
                        }
                        catch (StorageException e) {
                        }
                        finally {
                            inStream.close();
                        }
                    }
                    return result;
                }
                translatedException = task.materializeException(ExecutionEngine.getLastRequestObject(opContext), opContext);
                task.getResult().setException(translatedException);
                if (task.getResult().getStatusCode() == 501 || task.getResult().getStatusCode() == 505 || translatedException.getErrorCode().equals("InvalidBlobType")) {
                    throw translatedException;
                }
            }
            catch (TimeoutException e) {
                translatedException = StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
            }
            catch (SocketTimeoutException e) {
                translatedException = new StorageException("OperationTimedOut", "The operation did not complete in the specified time.", -1, null, e);
                task.getResult().setException(translatedException);
            }
            catch (IOException e) {
                translatedException = StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
            }
            catch (XMLStreamException e) {
                translatedException = e.getCause() instanceof SocketException ? new StorageException(StorageErrorCode.SERVICE_INTERNAL_ERROR.toString(), "An unknown failure occurred : ".concat(e.getCause().getMessage()), 500, null, e) : StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
                if (!(e.getCause() instanceof IOException) && !(e.getCause() instanceof SocketException)) {
                    throw translatedException;
                }
            }
            catch (InvalidKeyException e) {
                translatedException = StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
                throw translatedException;
            }
            catch (URISyntaxException e) {
                translatedException = StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
                throw translatedException;
            }
            catch (TableServiceException e) {
                task.getResult().setStatusCode(e.getHttpStatusCode());
                task.getResult().setStatusMessage(e.getMessage());
                task.getResult().setException(e);
                if (!e.isRetryable()) {
                    throw e;
                }
                translatedException = e;
            }
            catch (StorageException e) {
                task.getResult().setException(e);
                throw e;
            }
            catch (Exception e) {
                translatedException = StorageException.translateException(ExecutionEngine.getLastRequestObject(opContext), e, opContext);
                task.getResult().setException(translatedException);
                throw translatedException;
            }
            RetryResult retryRes = policy.shouldRetry(currentRetryCount, task.getResult().getStatusCode(), task.getResult().getException(), opContext);
            if (!retryRes.isShouldRetry()) {
                throw translatedException;
            }
            retryRes.doSleep();
            ++currentRetryCount;
        }
    }

    public static InputStream getInputStream(HttpURLConnection request, OperationContext opContext, RequestResult currResult) throws IOException {
        opContext.setCurrentRequestObject(request);
        currResult.setStartDate(new Date());
        if (opContext.getSendingRequestEventHandler().hasListeners()) {
            opContext.getSendingRequestEventHandler().fireEvent(new SendingRequestEvent(opContext, request, currResult));
        }
        try {
            return request.getInputStream();
        }
        catch (IOException ex) {
            ExecutionEngine.getResponseCode(currResult, request, opContext);
            throw ex;
        }
    }

    private static HttpURLConnection getLastRequestObject(OperationContext opContext) {
        if (opContext == null || opContext.getCurrentRequestObject() == null) {
            return null;
        }
        return opContext.getCurrentRequestObject();
    }

    public static void getResponseCode(RequestResult currResult, HttpURLConnection request, OperationContext opContext) throws IOException {
        currResult.setStatusCode(request.getResponseCode());
        currResult.setStatusMessage(request.getResponseMessage());
        currResult.setStopDate(new Date());
        currResult.setServiceRequestID(BaseResponse.getRequestId(request));
        currResult.setEtag(BaseResponse.getEtag(request));
        currResult.setRequestDate(BaseResponse.getDate(request));
        currResult.setContentMD5(BaseResponse.getContentMD5(request));
        if (opContext.getResponseReceivedEventHandler().hasListeners()) {
            opContext.getResponseReceivedEventHandler().fireEvent(new ResponseReceivedEvent(opContext, request, currResult));
        }
    }

    public static void processRequest(HttpURLConnection request, OperationContext opContext, RequestResult currResult) throws IOException {
        opContext.setCurrentRequestObject(request);
        currResult.setStartDate(new Date());
        if (opContext.getSendingRequestEventHandler().hasListeners()) {
            opContext.getSendingRequestEventHandler().fireEvent(new SendingRequestEvent(opContext, request, currResult));
        }
        currResult.setStatusCode(request.getResponseCode());
        currResult.setStatusMessage(request.getResponseMessage());
        currResult.setStopDate(new Date());
        currResult.setServiceRequestID(BaseResponse.getRequestId(request));
        currResult.setEtag(BaseResponse.getEtag(request));
        currResult.setRequestDate(BaseResponse.getDate(request));
        currResult.setContentMD5(BaseResponse.getContentMD5(request));
        if (opContext.getResponseReceivedEventHandler().hasListeners()) {
            opContext.getResponseReceivedEventHandler().fireEvent(new ResponseReceivedEvent(opContext, request, currResult));
        }
    }

    private ExecutionEngine() {
    }
}

