/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils.implementation;

import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BlobQueueFullCanonicalizer;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BlobQueueLiteCanonicalizer;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.Canonicalizer;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.TableFullCanonicalizer;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.TableLiteCanonicalizer;
import java.net.HttpURLConnection;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;

final class CanonicalizerFactory {
    private static final BlobQueueFullCanonicalizer BLOB_QUEUE_FULL_V2_INSTANCE = new BlobQueueFullCanonicalizer();
    private static final BlobQueueLiteCanonicalizer BLOB_QUEUE_LITE_INSTANCE = new BlobQueueLiteCanonicalizer();
    private static final TableFullCanonicalizer TABLE_FULL_INSTANCE = new TableFullCanonicalizer();
    private static final TableLiteCanonicalizer TABLE_LITE_INSTANCE = new TableLiteCanonicalizer();

    protected static Canonicalizer getBlobQueueFullCanonicalizer(HttpURLConnection conn) {
        if (CanonicalizerFactory.validateVersionIsSupported(conn).booleanValue()) {
            return BLOB_QUEUE_FULL_V2_INSTANCE;
        }
        throw new UnsupportedOperationException("Storage protocol version prior to 2009-09-19 are not supported.");
    }

    protected static Canonicalizer getBlobQueueLiteCanonicalizer(HttpURLConnection conn) {
        if (CanonicalizerFactory.validateVersionIsSupported(conn).booleanValue()) {
            return BLOB_QUEUE_LITE_INSTANCE;
        }
        throw new UnsupportedOperationException("Versions before 2009-09-19 do not support Shared Key Lite for Blob And Queue.");
    }

    protected static Canonicalizer getTableFullCanonicalizer(HttpURLConnection conn) {
        return TABLE_FULL_INSTANCE;
    }

    protected static Canonicalizer getTableLiteCanonicalizer(HttpURLConnection conn) {
        if (CanonicalizerFactory.validateVersionIsSupported(conn).booleanValue()) {
            return TABLE_LITE_INSTANCE;
        }
        throw new UnsupportedOperationException("Versions before 2009-09-19 do not support Shared Key Lite for Table.");
    }

    private static Boolean validateVersionIsSupported(HttpURLConnection conn) {
        String versionString = Utility.getStandardHeaderValue(conn, "x-ms-version");
        if (versionString.length() == 0 || versionString.length() == 0) {
            return true;
        }
        try {
            Calendar versionThresholdCalendar = Calendar.getInstance(Utility.LOCALE_US);
            versionThresholdCalendar.set(2009, 8, 19, 0, 0, 0);
            versionThresholdCalendar.set(14, 0);
            SimpleDateFormat versionFormat = new SimpleDateFormat("yyyy-MM-dd");
            Date versionDate = versionFormat.parse(versionString);
            Calendar requestVersionCalendar = Calendar.getInstance(Utility.LOCALE_US);
            requestVersionCalendar.setTime(versionDate);
            requestVersionCalendar.set(11, 0);
            requestVersionCalendar.set(12, 0);
            requestVersionCalendar.set(13, 0);
            requestVersionCalendar.set(14, 1);
            return requestVersionCalendar.compareTo(versionThresholdCalendar) >= 0;
        }
        catch (ParseException e) {
            return false;
        }
    }

    private CanonicalizerFactory() {
    }
}

