/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage.utils;

import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.UriQueryBuilder;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.Map;

public final class PathUtility {
    public static URI addToQuery(URI resourceURI, HashMap<String, String[]> fieldCollection) throws URISyntaxException, StorageException {
        UriQueryBuilder outUri = new UriQueryBuilder();
        for (Map.Entry<String, String[]> entry : fieldCollection.entrySet()) {
            for (String val : entry.getValue()) {
                outUri.add(entry.getKey(), val);
            }
        }
        return outUri.addToURI(resourceURI);
    }

    public static URI addToQuery(URI resourceURI, String queryString) throws URISyntaxException, StorageException {
        return PathUtility.addToQuery(resourceURI, PathUtility.parseQueryString(queryString));
    }

    public static URI appendPathToUri(URI uri, String relativeOrAbslouteUri) throws URISyntaxException {
        return PathUtility.appendPathToUri(uri, relativeOrAbslouteUri, "/");
    }

    public static URI appendPathToUri(URI uri, String relativeOrAbsoluteUri, String separator) throws URISyntaxException {
        int hostNameBeginIndex = -1;
        if (relativeOrAbsoluteUri.length() > 8) {
            String header = relativeOrAbsoluteUri.substring(0, 8).toLowerCase();
            if ("https://".equals(header)) {
                hostNameBeginIndex = 8;
            } else if ("http://".equals(header.substring(0, 7))) {
                hostNameBeginIndex = 7;
            }
        }
        if (hostNameBeginIndex > 0) {
            int authorityLength = relativeOrAbsoluteUri.substring(hostNameBeginIndex).indexOf(separator);
            String authorityName = relativeOrAbsoluteUri.substring(hostNameBeginIndex, hostNameBeginIndex + authorityLength);
            URI absoluteUri = new URI(relativeOrAbsoluteUri);
            if (uri.getAuthority().equals(authorityName)) {
                return absoluteUri;
            }
            return new URI(uri.getScheme(), uri.getAuthority(), absoluteUri.getPath(), absoluteUri.getRawQuery(), absoluteUri.getRawFragment());
        }
        if (uri.getPath().length() == 0 && relativeOrAbsoluteUri.startsWith(separator)) {
            return new URI(uri.getScheme(), uri.getAuthority(), relativeOrAbsoluteUri, uri.getRawQuery(), uri.getRawFragment());
        }
        StringBuilder pathString = new StringBuilder(uri.getPath());
        if (uri.getPath().endsWith(separator)) {
            pathString.append(relativeOrAbsoluteUri);
        } else {
            pathString.append(separator);
            pathString.append(relativeOrAbsoluteUri);
        }
        return new URI(uri.getScheme(), uri.getAuthority(), pathString.toString(), uri.getQuery(), uri.getFragment());
    }

    public static String getBlobNameFromURI(URI inURI, boolean usePathStyleUris) throws URISyntaxException {
        return Utility.safeRelativize(new URI(PathUtility.getContainerURI(inURI, usePathStyleUris).toString().concat("/")), inURI);
    }

    public static String getCanonicalPathFromCredentials(StorageCredentials credentials, String absolutePath) {
        String account = credentials.getAccountName();
        if (account == null) {
            String errorMessage = "Cannot create Shared Access Signature as the credentials does not have account name information. Please check that the credentials used support creating Shared Access Signature.";
            throw new IllegalArgumentException("Cannot create Shared Access Signature as the credentials does not have account name information. Please check that the credentials used support creating Shared Access Signature.");
        }
        StringBuilder builder = new StringBuilder("/");
        builder.append(account);
        builder.append(absolutePath);
        return builder.toString();
    }

    public static String getContainerNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid blob address '%s', missing container information", resourceAddress));
    }

    public static String getTableNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid table address '%s', missing table information", resourceAddress));
    }

    private static String getResourceNameFromUri(URI resourceAddress, boolean usePathStyleUris, String error) {
        int expectedPartsLength;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        String[] pathSegments = resourceAddress.getRawPath().split("/");
        int n = expectedPartsLength = usePathStyleUris ? 3 : 2;
        if (pathSegments.length < expectedPartsLength) {
            throw new IllegalArgumentException(error);
        }
        String resourceName = usePathStyleUris ? pathSegments[2] : pathSegments[1];
        return Utility.trimEnd(resourceName, '/');
    }

    public static URI getContainerURI(URI blobAddress, boolean usePathStyleUris) throws URISyntaxException {
        String containerName = PathUtility.getContainerNameFromUri(blobAddress, usePathStyleUris);
        URI containerUri = PathUtility.appendPathToUri(new URI(PathUtility.getServiceClientBaseAddress(blobAddress, usePathStyleUris)), containerName);
        return containerUri;
    }

    public static URI getParentAddress(URI blobAddress, String delimiter, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        String parentName = PathUtility.getParentNameFromURI(blobAddress, delimiter, usePathStyleUris);
        URI parentUri = PathUtility.appendPathToUri(new URI(PathUtility.getServiceClientBaseAddress(blobAddress, usePathStyleUris)), parentName);
        return parentUri;
    }

    public static String getParentNameFromURI(URI resourceAddress, String delimiter, boolean usePathStyleUris) throws URISyntaxException, StorageException {
        int lastDelimiterDex;
        URI relativeURI;
        String relativeURIString;
        Utility.assertNotNull("resourceAddress", resourceAddress);
        Utility.assertNotNullOrEmpty("delimiter", delimiter);
        String containerName = PathUtility.getContainerNameFromUri(resourceAddress, usePathStyleUris);
        URI baseURI = new URI(PathUtility.getServiceClientBaseAddress(resourceAddress, usePathStyleUris));
        if (usePathStyleUris && !baseURI.getRawPath().endsWith("/")) {
            baseURI = new URI(baseURI.getScheme(), baseURI.getRawAuthority(), baseURI.getRawPath().concat("/"), null, null);
        }
        if ((relativeURIString = (relativeURI = new URI(Utility.safeRelativize(baseURI, resourceAddress))).toString()).endsWith(delimiter)) {
            relativeURIString = relativeURIString.substring(0, relativeURIString.length() - delimiter.length());
        }
        String parentName = "";
        parentName = Utility.isNullOrEmpty(relativeURIString) ? containerName.concat(delimiter) : ((lastDelimiterDex = relativeURIString.lastIndexOf(delimiter)) <= 0 ? containerName.concat(delimiter) : relativeURIString.substring(0, lastDelimiterDex + delimiter.length()));
        return parentName;
    }

    public static String getQueueNameFromUri(URI resourceAddress, boolean usePathStyleUris) {
        return PathUtility.getResourceNameFromUri(resourceAddress, usePathStyleUris, String.format("Invalid queue URI '%s'.", resourceAddress));
    }

    public static String getServiceClientBaseAddress(URI address, boolean usePathStyleUris) throws URISyntaxException {
        if (usePathStyleUris) {
            String[] pathSegments = address.getRawPath().split("/");
            if (pathSegments.length < 2) {
                String error = String.format("Missing account name information inside path style uri. Path style uris should be of the form http://<IPAddressPlusPort>/<accountName>", new Object[0]);
                throw new IllegalArgumentException(error);
            }
            StringBuilder completeAddress = new StringBuilder(new URI(address.getScheme(), address.getAuthority(), null, null, null).toString());
            completeAddress.append("/");
            completeAddress.append(Utility.trimEnd(pathSegments[1], '/'));
            return completeAddress.toString();
        }
        return new URI(address.getScheme(), address.getAuthority(), null, null, null).toString();
    }

    public static HashMap<String, String[]> parseQueryString(String parseString) throws StorageException {
        HashMap<String, String[]> retVals = new HashMap<String, String[]>();
        if (Utility.isNullOrEmpty(parseString)) {
            return retVals;
        }
        int queryDex = parseString.indexOf("?");
        if (queryDex >= 0 && parseString.length() > 0) {
            parseString = parseString.substring(queryDex + 1);
        }
        String[] valuePairs = parseString.contains("&") ? parseString.split("&") : parseString.split(";");
        for (int m = 0; m < valuePairs.length; ++m) {
            int equalDex = valuePairs[m].indexOf("=");
            if (equalDex < 0 || equalDex == valuePairs[m].length() - 1) continue;
            String key = valuePairs[m].substring(0, equalDex);
            String value = valuePairs[m].substring(equalDex + 1);
            key = Utility.safeDecode(key);
            value = Utility.safeDecode(value);
            String[] values = retVals.get(key);
            if (values == null) {
                values = new String[]{value};
                if (value.equals("")) continue;
                retVals.put(key, values);
                continue;
            }
            if (value.equals("")) continue;
            String[] newValues = new String[values.length + 1];
            for (int j = 0; j < values.length; ++j) {
                newValues[j] = values[j];
            }
            newValues[newValues.length] = value;
        }
        return retVals;
    }

    public static URI stripURIQueryAndFragment(URI inUri) throws StorageException {
        try {
            return new URI(inUri.getScheme(), inUri.getAuthority(), inUri.getPath(), null, null);
        }
        catch (URISyntaxException e) {
            throw Utility.generateNewUnexpectedStorageException(e);
        }
    }

    private PathUtility() {
    }
}

