/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.services.core.storage;

import com.microsoft.windowsazure.services.core.storage.AuthenticationScheme;
import com.microsoft.windowsazure.services.core.storage.DoesServiceRequest;
import com.microsoft.windowsazure.services.core.storage.OperationContext;
import com.microsoft.windowsazure.services.core.storage.RequestOptions;
import com.microsoft.windowsazure.services.core.storage.RetryExponentialRetry;
import com.microsoft.windowsazure.services.core.storage.RetryPolicyFactory;
import com.microsoft.windowsazure.services.core.storage.ServiceProperties;
import com.microsoft.windowsazure.services.core.storage.StorageCredentials;
import com.microsoft.windowsazure.services.core.storage.StorageCredentialsAnonymous;
import com.microsoft.windowsazure.services.core.storage.StorageException;
import com.microsoft.windowsazure.services.core.storage.utils.StreamMd5AndLength;
import com.microsoft.windowsazure.services.core.storage.utils.Utility;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseRequest;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.BaseResponse;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.ExecutionEngine;
import com.microsoft.windowsazure.services.core.storage.utils.implementation.StorageOperation;
import java.io.ByteArrayInputStream;
import java.net.HttpURLConnection;
import java.net.URI;

public abstract class ServiceClient {
    protected URI endpoint;
    protected StorageCredentials credentials;
    private boolean usePathStyleUris;
    protected RetryPolicyFactory retryPolicyFactory = new RetryExponentialRetry();
    protected int timeoutInMs = 90000;
    protected AuthenticationScheme authenticationScheme = AuthenticationScheme.SHAREDKEYFULL;

    public ServiceClient(URI baseUri) {
        this(baseUri, null);
    }

    public ServiceClient(URI baseUri, StorageCredentials credentials) {
        Utility.assertNotNull("baseUri", baseUri);
        if (!baseUri.isAbsolute()) {
            throw new IllegalArgumentException(String.format("Address '%s' is not an absolute address. Relative addresses are not permitted in here.", baseUri));
        }
        this.credentials = credentials == null ? StorageCredentialsAnonymous.ANONYMOUS : credentials;
        this.retryPolicyFactory = new RetryExponentialRetry();
        this.timeoutInMs = 90000;
        this.usePathStyleUris = Utility.determinePathStyleFromUri(baseUri, this.credentials.getAccountName());
        this.endpoint = baseUri;
    }

    public final ServiceProperties downloadServiceProperties() throws StorageException {
        return this.downloadServiceProperties(null, null);
    }

    public final ServiceProperties downloadServiceProperties(RequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new RequestOptions();
        }
        opContext.initialize();
        options.applyBaseDefaults(this);
        StorageOperation<ServiceClient, Void, ServiceProperties> impl = new StorageOperation<ServiceClient, Void, ServiceProperties>(options){

            @Override
            public ServiceProperties execute(ServiceClient client, Void v, OperationContext opContext) throws Exception {
                HttpURLConnection request = BaseRequest.getServiceProperties(client.getEndpoint(), this.getRequestOptions().getTimeoutIntervalInMs(), null, opContext);
                this.setConnection(request);
                this.signRequest(client, request, -1L, null);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 200) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return BaseResponse.readServicePropertiesFromStream(request.getInputStream(), opContext);
            }
        };
        return ExecutionEngine.executeWithRetry(this, null, impl, options.getRetryPolicyFactory(), opContext);
    }

    public final StorageCredentials getCredentials() {
        return this.credentials;
    }

    public final AuthenticationScheme getAuthenticationScheme() {
        return this.authenticationScheme;
    }

    public final URI getEndpoint() {
        return this.endpoint;
    }

    public final RetryPolicyFactory getRetryPolicyFactory() {
        return this.retryPolicyFactory;
    }

    public final int getTimeoutInMs() {
        return this.timeoutInMs;
    }

    public final boolean isUsePathStyleUris() {
        return this.usePathStyleUris;
    }

    protected final void setBaseURI(URI baseUri) {
        this.usePathStyleUris = Utility.determinePathStyleFromUri(baseUri, this.credentials.getAccountName());
        this.endpoint = baseUri;
    }

    protected final void setCredentials(StorageCredentials credentials) {
        this.credentials = credentials;
    }

    public final void setAuthenticationScheme(AuthenticationScheme scheme) {
        this.authenticationScheme = scheme;
    }

    public void setRetryPolicyFactory(RetryPolicyFactory retryPolicyFactory) {
        this.retryPolicyFactory = retryPolicyFactory;
    }

    public final void setTimeoutInMs(int timeoutInMs) {
        this.timeoutInMs = timeoutInMs;
    }

    @DoesServiceRequest
    public void uploadServiceProperties(ServiceProperties properties) throws StorageException {
        this.uploadServiceProperties(properties, null, null);
    }

    @DoesServiceRequest
    public void uploadServiceProperties(final ServiceProperties properties, RequestOptions options, OperationContext opContext) throws StorageException {
        if (opContext == null) {
            opContext = new OperationContext();
        }
        if (options == null) {
            options = new RequestOptions();
        }
        opContext.initialize();
        options.applyBaseDefaults(this);
        Utility.assertNotNull("properties", properties);
        Utility.assertNotNull("properties.Logging", properties.getLogging());
        Utility.assertNotNull("properties.Logging.LogOperationTypes", properties.getLogging().getLogOperationTypes());
        Utility.assertNotNull("properties.Merics", properties.getMetrics());
        Utility.assertNotNull("properties.Merics.Configuration", (Object)properties.getMetrics().getMetricsLevel());
        StorageOperation<ServiceClient, Void, Void> impl = new StorageOperation<ServiceClient, Void, Void>(options){

            @Override
            public Void execute(ServiceClient client, Void v, OperationContext opContext) throws Exception {
                HttpURLConnection request = BaseRequest.setServiceProperties(client.getEndpoint(), this.getRequestOptions().getTimeoutIntervalInMs(), null, opContext);
                this.setConnection(request);
                byte[] propertiesBytes = BaseRequest.serializeServicePropertiesToByteArray(properties, opContext);
                ByteArrayInputStream dataInputStream = new ByteArrayInputStream(propertiesBytes);
                StreamMd5AndLength descriptor = Utility.analyzeStream(dataInputStream, -1L, -1L, true, true);
                request.setRequestProperty("Content-MD5", descriptor.getMd5());
                this.signRequest(client, request, descriptor.getLength(), null);
                Utility.writeToOutputStream(dataInputStream, request.getOutputStream(), descriptor.getLength(), false, false, null, opContext);
                ExecutionEngine.processRequest(request, opContext, this.getResult());
                if (this.getResult().getStatusCode() != 202) {
                    this.setNonExceptionedRetryableFailure(true);
                    return null;
                }
                return null;
            }
        };
        ExecutionEngine.executeWithRetry(this, null, impl, options.getRetryPolicyFactory(), opContext);
    }
}

